/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class BooleanType
implements VariableType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "boolean";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return valueFields.getLongValue() == 1L;
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value == null) {
            valueFields.setLongValue(null);
        } else {
            Boolean booleanValue = (Boolean)value;
            if (booleanValue.booleanValue()) {
                valueFields.setLongValue(1L);
            } else {
                valueFields.setLongValue(0L);
            }
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }
}

