/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.repository.Deployment;

public class DeploymentEntity
implements Serializable,
Deployment,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected String category;
    protected String tenantId = "";
    protected Map<String, ResourceEntity> resources;
    protected Date deploymentTime;
    protected boolean isNew;
    protected String procDefId;
    protected Map<Class<?>, List<Object>> deployedArtifacts;

    public ResourceEntity getResource(String resourceName) {
        return this.getResources().get(resourceName);
    }

    public void addResource(ResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, ResourceEntity>();
        }
        this.resources.put(resource.getName(), resource);
    }

    public Map<String, ResourceEntity> getResources() {
        if (this.resources == null && this.id != null) {
            List<ResourceEntity> resourcesList = Context.getCommandContext().getResourceEntityManager().findResourcesByDeploymentId(this.id);
            this.resources = new HashMap<String, ResourceEntity>();
            for (ResourceEntity resource : resourcesList) {
                this.resources.put(resource.getName(), resource);
            }
        }
        return this.resources;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("category", this.category);
        persistentState.put("tenantId", this.tenantId);
        return persistentState;
    }

    public void addDeployedArtifact(Object deployedArtifact) {
        Class<?> clazz;
        List<Object> artifacts;
        if (this.deployedArtifacts == null) {
            this.deployedArtifacts = new HashMap();
        }
        if ((artifacts = this.deployedArtifacts.get(clazz = deployedArtifact.getClass())) == null) {
            artifacts = new ArrayList<Object>();
            this.deployedArtifacts.put(clazz, artifacts);
        }
        artifacts.add(deployedArtifact);
    }

    public <T> List<T> getDeployedArtifacts(Class<T> clazz) {
        return this.deployedArtifacts.get(clazz);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setResources(Map<String, ResourceEntity> resources) {
        this.resources = resources;
    }

    @Override
    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public String toString() {
        return "DeploymentEntity[id=" + this.id + ", name=" + this.name + "]";
    }

    public Long getLongId() {
        return this.id == null ? null : Long.valueOf(Long.parseLong(this.id));
    }

    public void setLongId(Long id) {
        this.id = id == null ? null : id.toString();
    }

    @Override
    public String getProcDefId() {
        return this.procDefId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }
}

