/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.util.BpmActivitiSpringContextHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.JuelExpression;

public class UelExpressionCondition
implements Condition {
    private static final long serialVersionUID = 1L;
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    private static final String CONTAINS_ALL = "containsAll";
    private static final Pattern CONTAINS_ALL_REGEX = Pattern.compile(" (!)?([^ .])*.containsAll\\(([^)])*\\)");
    protected String initialConditionExpression;

    public UelExpressionCondition(String conditionExpression) {
        this.initialConditionExpression = conditionExpression;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        String conditionExpression = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = Context.getBpmnOverrideElementProperties(sequenceFlowId, execution.getProcessDefinitionId());
            conditionExpression = this.getActiveValue(this.initialConditionExpression, "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = this.initialConditionExpression;
        }
        HashMap<Object, Object> param = new HashMap<Object, Object>();
        Map<String, Object> variables = execution.getVariables();
        boolean isContainsAllCondition = conditionExpression.contains(CONTAINS_ALL);
        if (isContainsAllCondition) {
            Matcher matcher = CONTAINS_ALL_REGEX.matcher(conditionExpression);
            while (matcher.find()) {
                int indexA;
                String expr = matcher.group();
                String selectMultiVar = expr.substring(1, indexA = expr.indexOf("."));
                if (selectMultiVar.startsWith("!")) {
                    selectMultiVar = expr.substring(2, indexA);
                }
                String selectMultiVarString = String.valueOf(variables.get(selectMultiVar));
                ArrayList<String> selectMultiVarList = new ArrayList<String>(Arrays.asList(selectMultiVarString.split(",")));
                param.put(selectMultiVar, selectMultiVarList);
                int indexB = expr.indexOf("'");
                String varString = expr.substring(indexB, expr.length() - 1);
                String subVarString = varString.substring(1, varString.length() - 1);
                ArrayList<String> subVarList = new ArrayList<String>(Arrays.asList(subVarString.split(",")));
                IdGenerator idGenerator = (IdGenerator)BpmActivitiSpringContextHolder.getApplicationContext().getBean("workflowSnowflakeIDGenerator", IdGenerator.class);
                String nextId = "bpm_" + idGenerator.getNextId();
                String exprReplace = expr.replace(varString, nextId);
                conditionExpression = conditionExpression.replace(expr, exprReplace);
                param.put(nextId, subVarList);
            }
        }
        JuelExpression expression = (JuelExpression)Context.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression);
        Matcher matcher = BPM_NEXT_NODE_REGEX.matcher(expression.getExpressionText());
        String bpmNextNodeConditionValue = null;
        boolean isContains = false;
        if (matcher.find()) {
            String bpmNextNodeCondition = matcher.group();
            isContains = bpmNextNodeCondition.contains("==");
            bpmNextNodeConditionValue = bpmNextNodeCondition.substring(18, bpmNextNodeCondition.length() - 1);
        }
        Object result = null;
        String nextNodes = (String)Context.getCommandContext().getAttribute("bpm_next_node");
        if (nextNodes != null && bpmNextNodeConditionValue != null) {
            boolean contains = Arrays.asList(nextNodes.split(",")).contains(bpmNextNodeConditionValue);
            param.put("bpm_next_node", isContains && contains ? bpmNextNodeConditionValue : "");
        }
        if ((result = HussarUtils.isNotEmpty(param) ? expression.getValue(execution, param) : expression.getValue(execution)) == null) {
            throw new ActivitiException("condition expression returns null");
        }
        if (!(result instanceof Boolean)) {
            throw new ActivitiException("condition expression returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

