/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.jxdinfo.hussar.workflow.util.BpmActivityExceptionUtil;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.runtime.Execution;

public abstract class AbstractSetProcessInstanceStateCmd
implements Command<Void> {
    protected final String executionId;

    public AbstractSetProcessInstanceStateCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("ProcessInstanceId cannot be null.");
        }
        ExecutionEntity executionEntity = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        if (executionEntity == null) {
            throw new ActivitiObjectNotFoundException("Cannot find processInstance for id '" + this.executionId + "'.", Execution.class);
        }
        if (!executionEntity.isProcessInstanceType()) {
            BpmActivityExceptionUtil.throwBpmException(new ActivitiException("Cannot set suspension state for execution '" + this.executionId + "': not a process instance."));
        }
        SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity, this.getNewState());
        List<ExecutionEntity> childExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.executionId);
        for (ExecutionEntity childExecution : childExecutions) {
            if (childExecution.getId().equals(this.executionId)) continue;
            SuspensionState.SuspensionStateUtil.setSuspensionState(childExecution, this.getNewState());
        }
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(this.executionId);
        for (TaskEntity taskEntity : tasks) {
            SuspensionState.SuspensionStateUtil.setSuspensionState(taskEntity, this.getNewState());
        }
        if (SuspensionState.SUSPENDED == this.getNewState()) {
            executionEntity.fireEventExecution("suspend");
        }
        if (SuspensionState.ACTIVE == this.getNewState()) {
            executionEntity.fireEventExecution("active");
        }
        return null;
    }

    protected abstract SuspensionState getNewState();
}

