/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.TaskWithFieldExtensions;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.FixedValue;
import org.apache.commons.lang3.StringUtils;

public class DelegateHelper {
    public static BpmnModel getBpmnModel(DelegateExecution execution) {
        if (execution == null) {
            throw new ActivitiException("Null execution passed");
        }
        return Context.getCommandContext().getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(execution.getProcessDefinitionId());
    }

    public static FlowElement getFlowElement(DelegateExecution execution) {
        BpmnModel bpmnModel = DelegateHelper.getBpmnModel(execution);
        FlowElement flowElement = bpmnModel.getFlowElement(execution.getCurrentActivityId());
        if (flowElement == null) {
            throw new ActivitiException("Could not find a FlowElement for activityId " + execution.getCurrentActivityId());
        }
        return flowElement;
    }

    public static Map<String, List<ExtensionElement>> getExtensionElements(DelegateExecution execution) {
        return DelegateHelper.getFlowElement(execution).getExtensionElements();
    }

    public static List<FieldExtension> getFields(DelegateExecution execution) {
        FlowElement flowElement = DelegateHelper.getFlowElement(execution);
        if (flowElement instanceof TaskWithFieldExtensions) {
            return ((TaskWithFieldExtensions)flowElement).getFieldExtensions();
        }
        return new ArrayList<FieldExtension>();
    }

    public static FieldExtension getField(DelegateExecution execution, String fieldName) {
        List<FieldExtension> fieldExtensions = DelegateHelper.getFields(execution);
        if (fieldExtensions == null || fieldExtensions.size() == 0) {
            return null;
        }
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName() == null || !fieldExtension.getFieldName().equals(fieldName)) continue;
            return fieldExtension;
        }
        return null;
    }

    public static Expression createExpressionForField(FieldExtension fieldExtension) {
        if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression())) {
            ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
            return expressionManager.createExpression(fieldExtension.getExpression());
        }
        return new FixedValue(fieldExtension.getStringValue());
    }

    public static Expression getFieldExpression(DelegateExecution execution, String fieldName) {
        FieldExtension fieldExtension = DelegateHelper.getField(execution, fieldName);
        if (fieldExtension != null) {
            return DelegateHelper.createExpressionForField(fieldExtension);
        }
        return null;
    }
}

