/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.IntStream;

public interface PrefixMap<V extends Serializable>
extends Serializable,
Map<String, V> {
    @Override
    public int size();

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public void putAll(Map<? extends String, ? extends V> prefixesAndValues) {
        prefixesAndValues.forEach(this::put);
    }

    @Override
    public V put(String var1, V var2);

    default public V remove(String prefix) {
        throw new UnsupportedOperationException("The 'remove(String prefix)' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    default public V remove(Object o) {
        throw new UnsupportedOperationException("The 'remove(Object o)' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    default public boolean containsKey(Object o) {
        throw new UnsupportedOperationException("The 'containsKey(Object o)' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    default public boolean containsValue(Object o) {
        throw new UnsupportedOperationException("The 'containsValue(Object o)' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    public V get(String var1);

    @Override
    default public V get(Object prefix) {
        throw new UnsupportedOperationException("The 'get(Object)' method ONLY accepts keys of type String");
    }

    @Override
    default public Set<String> keySet() {
        throw new UnsupportedOperationException("The 'keySet()' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    default public Collection<V> values() {
        throw new UnsupportedOperationException("The 'values()' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException("The 'clear()' method has not been implemented in " + this.getClass().getCanonicalName());
    }

    default public boolean containsPrefix(String prefix) {
        return this.containsPrefix(prefix.codePoints().iterator());
    }

    default public V getShortestMatch(String input) {
        return this.getShortestMatch(input.codePoints().iterator());
    }

    default public V getLongestMatch(String input) {
        return this.getLongestMatch(input.codePoints().iterator());
    }

    default public Iterator<V> getAllMatches(String input) {
        return this.getAllMatches(input.codePoints().iterator());
    }

    default public boolean containsPrefix(int[] prefix) {
        return this.containsPrefix(IntStream.of(prefix).iterator());
    }

    default public V getShortestMatch(int[] input) {
        return this.getShortestMatch(IntStream.of(input).iterator());
    }

    default public V getLongestMatch(int[] input) {
        return this.getLongestMatch(IntStream.of(input).iterator());
    }

    default public Iterator<V> getAllMatches(int[] input) {
        return this.getAllMatches(IntStream.of(input).iterator());
    }

    public boolean containsPrefix(PrimitiveIterator.OfInt var1);

    public V getShortestMatch(PrimitiveIterator.OfInt var1);

    public V getLongestMatch(PrimitiveIterator.OfInt var1);

    public Iterator<V> getAllMatches(PrimitiveIterator.OfInt var1);
}

