/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.handWriting;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sourceforge.javaocr.ocrPlugins.handWriting.CandidateOCRChoice;
import net.sourceforge.javaocr.scanner.accuracy.OCRIdentification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultAnalyzer {
    private ArrayList<OCRIdentification> mseCharIdentList;
    private ArrayList<OCRIdentification> apsectCharIdentList;
    private int listSize;
    private static final Logger LOG = Logger.getLogger(ResultAnalyzer.class.getName());

    public ResultAnalyzer(ArrayList<OCRIdentification> mseCharIdentList, ArrayList<OCRIdentification> aspectCharIdentList) {
        this.mseCharIdentList = mseCharIdentList;
        this.apsectCharIdentList = aspectCharIdentList;
        this.listSize = this.getListSize();
    }

    public String calculateResultAndReturnString() {
        String result = "";
        ArrayList<CandidateOCRChoice> choices = this.getCharChoices();
        for (CandidateOCRChoice choice : choices) {
            ArrayList<OCRIdentification> OCRResultsForChar = choice.getRankedIdentList();
            result = result + this.getHighestRankResult(OCRResultsForChar);
        }
        return result;
    }

    private char getHighestRankResult(ArrayList<OCRIdentification> OCRResultsForChar) {
        char recommendedChar = ' ';
        for (OCRIdentification currOCRIdentification : OCRResultsForChar) {
            if (currOCRIdentification.getNumChars() <= 0) continue;
            recommendedChar = currOCRIdentification.getCharIdx(0);
        }
        return recommendedChar;
    }

    private ArrayList<CandidateOCRChoice> getCharChoices() {
        ArrayList<CandidateOCRChoice> choices = new ArrayList<CandidateOCRChoice>();
        for (int i = 0; i < this.listSize; ++i) {
            OCRIdentification currIdent;
            CandidateOCRChoice cand = new CandidateOCRChoice();
            if (!this.mseCharIdentList.isEmpty()) {
                currIdent = this.mseCharIdentList.get(i);
                cand.addOCRIdent(currIdent);
            }
            if (!this.apsectCharIdentList.isEmpty()) {
                currIdent = this.apsectCharIdentList.get(i);
                cand.addOCRIdent(currIdent);
            }
            choices.add(cand);
        }
        return choices;
    }

    private int getListSize() {
        int size = 0;
        if (this.apsectCharIdentList.size() > size) {
            size = this.apsectCharIdentList.size();
        }
        if (this.mseCharIdentList.size() > size) {
            size = this.mseCharIdentList.size();
        }
        return size;
    }
}

