/*
 * Decompiled with CFR 0.152.
 */
package net.somta.core.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

public final class JsonSerializeHelper {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> String serialize(T value) throws JsonProcessingException {
        return objectMapper.writeValueAsString(value);
    }

    public static <T> T deserialize(String value, Class<T> valueClass) throws JsonProcessingException {
        return (T)objectMapper.readValue(value, valueClass);
    }

    public static <T> T deserialize(String data, Class<T> clazz, Class<?> elementClass) throws JsonProcessingException {
        return (T)objectMapper.readValue(data, JsonSerializeHelper.getGenericsType(clazz, elementClass));
    }

    private static JavaType getGenericsType(Class<?> clazz, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(clazz, (Class[])elementClasses);
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }
}

