/*
 * Decompiled with CFR 0.152.
 */
package net.somta.core.cache.redis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.somta.core.base.IBaseError;
import net.somta.core.cache.redis.client.AbstractRedisClient;
import net.somta.core.cache.redis.client.ClusterRedisClient;
import net.somta.core.cache.redis.client.SentinelRedisClient;
import net.somta.core.cache.redis.client.SingleRedisClient;
import net.somta.core.cache.redis.exception.RedisException;
import net.somta.core.cache.redis.model.RedisConfigItem;
import net.somta.core.cache.redis.model.RedisErrorEnum;
import net.somta.core.cache.redis.model.RedisModeEnum;
import net.somta.core.cache.redis.serialize.InterfaceSerializable;
import net.somta.core.cache.redis.serialize.JsonSerializable;
import org.apache.commons.lang3.ArrayUtils;

public class RedisClientBuilder {
    private static Map<String, AbstractRedisClient> redisClients = new HashMap<String, AbstractRedisClient>();

    public static AbstractRedisClient buildRedisClient(RedisConfigItem redisConfigItem) {
        return RedisClientBuilder.buildRedisClient(redisConfigItem, null);
    }

    public static synchronized AbstractRedisClient buildRedisClient(RedisConfigItem redisConfigItem, InterfaceSerializable interfaceSerializable) {
        if (ArrayUtils.isEmpty((Object[])redisConfigItem.getAddress())) {
            throw new RedisException((IBaseError)RedisErrorEnum.REDIS_ADDRESS_ERROR, new Object[0]);
        }
        AbstractRedisClient cacheRedisClient = redisClients.get(Arrays.toString(redisConfigItem.getAddress()));
        if (cacheRedisClient != null) {
            return cacheRedisClient;
        }
        if (interfaceSerializable == null) {
            interfaceSerializable = new JsonSerializable();
        }
        AbstractRedisClient redisClient = null;
        if (RedisModeEnum.single.name().equals(redisConfigItem.getModel())) {
            redisClient = new SingleRedisClient();
        } else if (RedisModeEnum.sentinel.name().equals(redisConfigItem.getModel())) {
            redisClient = new SentinelRedisClient();
        } else if (RedisModeEnum.cluster.name().equals(redisConfigItem.getModel())) {
            redisClient = new ClusterRedisClient();
        } else {
            throw new RedisException((IBaseError)RedisErrorEnum.REDIS_MODE_ERROR, redisConfigItem.getModel());
        }
        redisClient.init(redisConfigItem);
        redisClient.setInterfaceSerializable(interfaceSerializable);
        redisClients.put(Arrays.toString(redisConfigItem.getAddress()), redisClient);
        return redisClient;
    }
}

