/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.result.data;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.somta.juggle.core.model.DataType;
import net.somta.juggle.core.model.Property;
import net.somta.juggle.core.model.Variable;
import net.somta.juggle.core.variable.AbstractVariableManager;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractResultDataProcessor {
    private AbstractVariableManager g;

    public AbstractResultDataProcessor(AbstractVariableManager variableManager) {
        this.g = variableManager;
    }

    public void fillDataResultToVariable(ResultSet resultSet, String outputVariableKey) {
        Variable variable = this.g.getVariableSchema(outputVariableKey);
        Object result = null;
        try {
            result = this.a(resultSet, variable);
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
        this.g.setVariableValue(outputVariableKey, result);
    }

    protected static Object a(ResultSet resultSet, Property property) throws SQLException {
        DataType dataType = property.getDataType();
        if (!AbstractResultDataProcessor.a(resultSet, property.getPropKey())) {
            return null;
        }
        switch (dataType.getType()) {
            case String: {
                return resultSet.getString(property.getPropKey());
            }
            case Integer: {
                return resultSet.getInt(property.getPropKey());
            }
            case Double: {
                return resultSet.getDouble(property.getPropKey());
            }
        }
        return null;
    }

    private static boolean a(ResultSet resultSet, String propKey) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (columnCount <= 0) {
            return false;
        }
        for (int i2 = 1; i2 <= columnCount; ++i2) {
            String columnName = metaData.getColumnLabel(i2);
            if (!StringUtils.isNotEmpty((CharSequence)columnName) || !columnName.equals(propKey)) continue;
            return true;
        }
        return false;
    }

    protected abstract Object a(ResultSet var1, Variable var2) throws SQLException;
}

