/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.result;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.somta.core.cache.redis.client.AbstractRedisClient;
import net.somta.juggle.core.result.IFlowResultManager;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;

public class RedisFlowResultManager
implements IFlowResultManager {
    private final RedissonClient br;

    public RedisFlowResultManager(AbstractRedisClient redisClient) {
        this.br = redisClient.getRedissonClient();
    }

    @Override
    public boolean putFlowResult(String flowInstanceId, Map<String, Object> resultData) {
        RMap map = this.br.getMap(flowInstanceId);
        Map<String, Object> noNullValueResultMap = resultData;
        if (resultData != null) {
            noNullValueResultMap = resultData.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        map.putAll(noNullValueResultMap);
        return true;
    }

    @Override
    public Map<String, Object> getFlowResult(String flowInstanceId) {
        RMap map = this.br.getMap(flowInstanceId);
        Map cacheMap = map.readAllMap();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        for (String mapKey : cacheMap.keySet()) {
            Object value = cacheMap.get(mapKey);
            resultMap.put(mapKey, value);
        }
        return resultMap;
    }
}

