/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.expression;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import java.util.HashMap;
import java.util.List;
import net.somta.juggle.core.exception.a;
import net.somta.juggle.core.expression.condition.parser.d;
import net.somta.juggle.core.expression.condition.parser.e;
import net.somta.juggle.core.model.node.ConditionNode;
import net.somta.juggle.core.variable.AbstractVariableManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionManager {
    private static final Logger k = LoggerFactory.getLogger(ExpressionManager.class);
    private AviatorEvaluatorInstance L = AviatorEvaluator.getInstance();
    private final AbstractVariableManager g;

    public ExpressionManager(AbstractVariableManager variableManager) {
        this.g = variableManager;
    }

    public boolean executeExpression(String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return true;
        }
        Expression compiledExp = this.L.compile(expression, true);
        List variableKeys = compiledExp.getVariableNames();
        HashMap<String, Object> env = new HashMap<String, Object>(8);
        for (String key : variableKeys) {
            try {
                env.put(key, this.g.getVariableValue(key));
            }
            catch (a e2) {
                e2.printStackTrace();
            }
        }
        boolean result = (Boolean)compiledExp.execute(env);
        k.debug("expression:{},env:{},result", new Object[]{expression, env, result});
        return result;
    }

    public static String generateExpression(List<List<ConditionNode.ConditionExpression>> expressionList) {
        if (CollectionUtils.isEmpty(expressionList)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < expressionList.size(); ++i2) {
            List<ConditionNode.ConditionExpression> andExpressionList = expressionList.get(i2);
            String andExpression = ExpressionManager.a(andExpressionList);
            stringBuilder.append(andExpression);
            if (i2 >= expressionList.size() - 1) continue;
            stringBuilder.append("||");
        }
        return stringBuilder.toString();
    }

    private static String a(List<ConditionNode.ConditionExpression> andExpressionList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < andExpressionList.size(); ++i2) {
            ConditionNode.ConditionExpression conditionExpression = andExpressionList.get(i2);
            e expressionParser = d.a(conditionExpression.getDataType());
            String expression = expressionParser.a(conditionExpression);
            stringBuilder.append(expression);
            if (i2 >= andExpressionList.size() - 1) continue;
            stringBuilder.append("&&");
        }
        return stringBuilder.toString();
    }
}

