/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.revelc.code.impsort.Grouper;
import net.revelc.code.impsort.ImpSort;
import net.revelc.code.impsort.LineEnding;
import net.revelc.code.impsort.Result;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;

abstract class AbstractImpSortMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.java"};
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${project.build.sourceEncoding}", readonly=true)
    protected String sourceEncoding = StandardCharsets.UTF_8.name();
    @Parameter(alias="skip", property="impsort.skip", defaultValue="false")
    private boolean skip;
    @Parameter(alias="staticGroups", property="impsort.staticGroups", defaultValue="*")
    protected String staticGroups;
    @Parameter(alias="groups", property="impsort.groups", defaultValue="*")
    protected String groups;
    @Parameter(alias="staticAfter", property="impsort.staticAfter", defaultValue="false")
    protected boolean staticAfter;
    @Parameter(alias="joinStaticWithNonStatic", property="impsort.joinStaticWithNonStatic", defaultValue="false")
    protected boolean joinStaticWithNonStatic;
    @Parameter(alias="sourceDirectory", defaultValue="${project.build.sourceDirectory}", readonly=true)
    private File sourceDirectory;
    @Parameter(alias="testSourceDirectory", defaultValue="${project.build.testSourceDirectory}", readonly=true)
    private File testSourceDirectory;
    @Parameter(alias="directories", property="impsort.directories")
    private File[] directories;
    @Parameter(alias="includes", property="impsort.includes")
    private String[] includes;
    @Parameter(alias="excludes", property="impsort.excludes")
    private String[] excludes;
    @Parameter(alias="removeUnused", property="impsort.removeUnused", defaultValue="false")
    private boolean removeUnused;
    @Parameter(alias="treatSamePackageAsUnused", property="impsort.treatSamePackageAsUnused", defaultValue="true")
    private boolean treatSamePackageAsUnused;
    @Parameter(alias="breadthFirstComparator", property="impsort.breadthFirstComparator", defaultValue="true")
    private boolean breadthFirstComparator;
    @Parameter(alias="lineEnding", property="impsort.lineEnding", defaultValue="AUTO")
    private LineEnding lineEnding;

    AbstractImpSortMojo() {
    }

    abstract void processResult(Path var1, Result var2) throws MojoFailureException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of impsort-maven-plugin");
            return;
        }
        Stream files = this.directories != null && this.directories.length > 0 ? (Stream)Stream.of(this.directories).flatMap(d -> this.searchDir((File)d, true)).parallel() : (Stream)Stream.of(this.sourceDirectory, this.testSourceDirectory).flatMap(d -> this.searchDir((File)d, false)).parallel();
        Stream<Path> paths = files.map(File::toPath);
        Grouper grouper = new Grouper(this.groups, this.staticGroups, this.staticAfter, this.joinStaticWithNonStatic, this.breadthFirstComparator);
        Charset encoding = Charset.forName(this.sourceEncoding);
        ImpSort impSort = new ImpSort(encoding, grouper, this.removeUnused, this.treatSamePackageAsUnused, this.lineEnding);
        AtomicLong numAlreadySorted = new AtomicLong(0L);
        AtomicLong numProcessed = new AtomicLong(0L);
        Function<Path, MojoFailureException> visitor = path -> {
            try {
                this.getLog().debug((CharSequence)("Reading file " + path));
                try {
                    Result result = impSort.parseFile((Path)path);
                    result.getImports().forEach(imp -> this.getLog().debug((CharSequence)("Found import: " + imp)));
                    if (result.isSorted()) {
                        numAlreadySorted.getAndIncrement();
                    } else {
                        numProcessed.getAndIncrement();
                    }
                    this.processResult((Path)path, result);
                }
                catch (IOException e) {
                    this.fail("Error reading file " + path, e);
                }
                return null;
            }
            catch (MojoFailureException e) {
                return e;
            }
        };
        Predicate<MojoFailureException> notNull = e -> e != null;
        BinaryOperator agg = (e1, e2) -> {
            e1.addSuppressed((Throwable)e2);
            return e1;
        };
        long startTime = System.nanoTime();
        MojoFailureException failure = paths.map(visitor).filter(notNull).reduce(agg).orElse(null);
        Duration totalTime = Duration.ofNanos(System.nanoTime() - startTime);
        long total = numAlreadySorted.get() + numProcessed.get();
        long minutes = totalTime.getSeconds() / 60L;
        long seconds = totalTime.getSeconds() - minutes * 60L;
        long millis = totalTime.getNano() / 1000000;
        String fmt = "%22s: %" + Long.toString(total).length() + "d";
        this.getLog().info((CharSequence)String.format(fmt + " in %02d:%02d.%03d", "Total Files Processed", total, minutes, seconds, millis));
        this.getLog().info((CharSequence)String.format(fmt, "Already Sorted", numAlreadySorted.get()));
        this.getLog().info((CharSequence)String.format(fmt, "Needed Sorting", numProcessed.get()));
        if (failure != null) {
            throw failure;
        }
    }

    private Stream<File> searchDir(File dir, boolean warnOnBadDir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            if (warnOnBadDir && dir != null) {
                this.getLog().warn((CharSequence)("Directory does not exist or is not a directory: " + dir));
            }
            return Stream.empty();
        }
        this.getLog().debug((CharSequence)("Adding directory " + dir));
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(dir);
        ds.setIncludes(this.includes != null && this.includes.length > 0 ? this.includes : DEFAULT_INCLUDES);
        ds.setExcludes(this.excludes);
        ds.addDefaultExcludes();
        ds.setCaseSensitive(false);
        ds.setFollowSymlinks(false);
        ds.scan();
        return (Stream)Stream.of(ds.getIncludedFiles()).map(filename -> new File(dir, (String)filename)).parallel();
    }

    protected void fail(String message) throws MojoFailureException {
        this.fail(message, null);
    }

    protected void fail(String message, Throwable cause) throws MojoFailureException {
        throw cause == null ? new MojoFailureException(message) : new MojoFailureException(message, cause);
    }
}

