/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml.lib;

public class FormattingPreferences {
    public static final String IGNORE = "IGNORE";
    public static final String WARN = "WARN";
    public static final String FAIL = "FAIL";
    private int maxLineLength = 120;
    private boolean wrapLongLines = true;
    private boolean tabInsteadOfSpaces = true;
    private int tabWidth = 4;
    private boolean splitMultiAttrs;
    private String wellFormedValidation = "WARN";
    private boolean deleteBlankLines;

    public String getCanonicalIndent() {
        String canonicalIndent;
        if (this.useTabInsteadOfSpaces()) {
            canonicalIndent = "\t";
        } else {
            String tab = "";
            for (int i = 0; i < this.getTabWidth(); ++i) {
                tab = tab.concat(" ");
            }
            canonicalIndent = tab;
        }
        return canonicalIndent;
    }

    public boolean getDeleteBlankLines() {
        return this.deleteBlankLines;
    }

    public int getMaximumLineWidth() {
        return this.maxLineLength;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public String getWellFormedValidation() {
        return this.wellFormedValidation;
    }

    public boolean isSplitMultiAttrs() {
        return this.splitMultiAttrs;
    }

    public void setDeleteBlankLines(boolean deleteBlankLines) {
        this.deleteBlankLines = deleteBlankLines;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public void setSplitMultiAttrs(boolean setSplitMultiAttrs) {
        this.splitMultiAttrs = setSplitMultiAttrs;
    }

    public void setTabInsteadOfSpaces(boolean tabInsteadOfSpaces) {
        this.tabInsteadOfSpaces = tabInsteadOfSpaces;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public void setWellFormedValidation(String wellFormedValidation) {
        if (!(wellFormedValidation.equals(IGNORE) || wellFormedValidation.equals(FAIL) || wellFormedValidation.equals(WARN))) {
            throw new IllegalArgumentException("Invalid configuration value for well formed validation: " + wellFormedValidation);
        }
        this.wellFormedValidation = wellFormedValidation;
    }

    public void setWrapLongLines(boolean wrapLongLines) {
        this.wrapLongLines = wrapLongLines;
    }

    public boolean useTabInsteadOfSpaces() {
        return this.tabInsteadOfSpaces;
    }

    public boolean wrapLongTags() {
        return this.wrapLongLines;
    }
}

