/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.css;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

public class CssFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private CSSFormat formatter;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        int indent = Integer.parseInt(options.getOrDefault("indent", "4"));
        boolean rgbAsHex = Boolean.parseBoolean(options.getOrDefault("rgbAsHex", Boolean.TRUE.toString()));
        boolean useSourceStringValues = Boolean.parseBoolean(options.getOrDefault("useSourceStringValues", Boolean.FALSE.toString()));
        this.formatter = new CSSFormat().setPropertiesInSeparateLines(indent).setRgbAsHex(rgbAsHex).setUseSourceStringValues(useSourceStringValues);
    }

    @Override
    protected String doFormat(String code, LineEnding ending) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(code));
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleSheetImpl sheet = (CSSStyleSheetImpl)parser.parseStyleSheet(source, null, null);
        String formattedCode = sheet.getCssText(this.formatter);
        if (code.equals(formattedCode = formattedCode.replace("\t;", "\\9;"))) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

