/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.accessevent;

import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.core.joran.spi.DefaultClass;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.composite.accessevent.HeaderFilter;
import net.logstash.logback.composite.accessevent.IncludeExcludeHeaderFilter;
import net.logstash.logback.fieldnames.LogstashAccessFieldNames;

public class ResponseHeadersJsonProvider
extends AbstractFieldJsonProvider<IAccessEvent>
implements FieldNamesAware<LogstashAccessFieldNames> {
    private boolean lowerCaseHeaderNames = true;
    private HeaderFilter filter;

    @Override
    public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
        HashMap<String, String> headers;
        if (this.filter == null) {
            headers = event.getResponseHeaderMap();
        } else {
            headers = new HashMap<String, String>(event.getResponseHeaderMap().size());
            for (Map.Entry header : event.getResponseHeaderMap().entrySet()) {
                if (!this.filter.includeHeader((String)header.getKey(), (String)header.getValue())) continue;
                headers.put((String)header.getKey(), (String)header.getValue());
            }
        }
        JsonWritingUtils.writeMapStringFields(generator, this.getFieldName(), headers, this.lowerCaseHeaderNames);
    }

    @Override
    public void setFieldNames(LogstashAccessFieldNames fieldNames) {
        this.setFieldName(fieldNames.getResponseHeaders());
    }

    public boolean getLowerCaseHeaderNames() {
        return this.lowerCaseHeaderNames;
    }

    public void setLowerCaseHeaderNames(boolean lowerCaseHeaderNames) {
        this.lowerCaseHeaderNames = lowerCaseHeaderNames;
    }

    public HeaderFilter getFilter() {
        return this.filter;
    }

    @DefaultClass(value=IncludeExcludeHeaderFilter.class)
    public void setFilter(HeaderFilter filter) {
        this.filter = filter;
    }
}

