/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.ArrayComparison;
import net.javacrumbs.jsonunit.core.internal.ClassUtils;
import net.javacrumbs.jsonunit.core.internal.Context;
import net.javacrumbs.jsonunit.core.internal.DifferenceContextImpl;
import net.javacrumbs.jsonunit.core.internal.DifferenceImpl;
import net.javacrumbs.jsonunit.core.internal.Differences;
import net.javacrumbs.jsonunit.core.internal.ExceptionUtils;
import net.javacrumbs.jsonunit.core.internal.HamcrestHandler;
import net.javacrumbs.jsonunit.core.internal.JsonDifference;
import net.javacrumbs.jsonunit.core.internal.JsonSource;
import net.javacrumbs.jsonunit.core.internal.JsonUnitLogger;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Normalizer;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.PathMatcher;
import net.javacrumbs.jsonunit.core.internal.PathOptionMatcher;
import net.javacrumbs.jsonunit.core.listener.Difference;
import org.opentest4j.AssertionFailedError;

public class Diff {
    private static final Pattern ANY_NUMBER_PLACEHOLDER = Pattern.compile("[$#]\\{json-unit.any-number\\}");
    private static final Pattern ANY_BOOLEAN_PLACEHOLDER = Pattern.compile("[$#]\\{json-unit.any-boolean\\}");
    private static final Pattern ANY_STRING_PLACEHOLDER = Pattern.compile("[$#]\\{json-unit.any-string\\}");
    private static final Pattern REGEX_PLACEHOLDER = Pattern.compile("[$#]\\{json-unit.regex\\}(.*)");
    private static final Pattern MATCHER_PLACEHOLDER_PATTERN = Pattern.compile("[$#]\\{json-unit.matches:(.+?)\\}(.*)", 32);
    private static final JsonUnitLogger DEFAULT_DIFF_LOGGER = Diff.createLogger("net.javacrumbs.jsonunit.difference.diff");
    private static final JsonUnitLogger DEFAULT_VALUE_LOGGER = Diff.createLogger("net.javacrumbs.jsonunit.difference.values");
    static final String DEFAULT_DIFFERENCE_STRING = "expected: <%s> but was: <%s>";
    private final Node expectedRoot;
    private final Node actualRoot;
    private final Differences differences = new Differences();
    private final Path startPath;
    private boolean compared = false;
    private final Configuration configuration;
    private final PathMatcher pathsToBeIgnored;
    private final Map<Option, List<PathOptionMatcher>> specificPathOptions;
    private final JsonUnitLogger diffLogger;
    private final JsonUnitLogger valuesLogger;
    private final String differenceString;

    Diff(Node expected, Node actual, Path startPath, Configuration configuration, JsonUnitLogger diffLogger, JsonUnitLogger valuesLogger, String differenceString) {
        this.expectedRoot = expected;
        this.actualRoot = actual;
        this.startPath = startPath;
        this.configuration = configuration;
        this.diffLogger = diffLogger;
        this.valuesLogger = valuesLogger;
        this.pathsToBeIgnored = PathMatcher.create(configuration.getPathsToBeIgnored());
        this.specificPathOptions = configuration.getPathOptions().stream().flatMap(PathOptionMatcher::createMatchersFromPathOption).collect(Collectors.groupingBy(PathOptionMatcher::getOption));
        this.differenceString = differenceString;
    }

    public static Diff create(Object expected, Object actual, String actualName, String path, Configuration configuration) {
        if (actual instanceof JsonSource) {
            return Diff.create(expected, actual, actualName, Path.create(path, ((JsonSource)actual).getPathPrefix()), configuration);
        }
        return Diff.create(expected, actual, actualName, Path.create(path, ""), configuration);
    }

    public static Diff create(Object expected, Object actual, String actualName, Path path, Configuration configuration) {
        return Diff.createInternal(expected, actual, actualName, path, configuration, DEFAULT_DIFFERENCE_STRING);
    }

    public static Diff createInternal(Object expected, Object actual, String actualName, Path path, Configuration configuration, String differenceString) {
        return new Diff(JsonUtils.convertToJson(JsonUtils.quoteIfNeeded(expected), "expected", true), JsonUtils.convertToJson(actual, actualName, false), path, configuration, DEFAULT_DIFF_LOGGER, DEFAULT_VALUE_LOGGER, differenceString);
    }

    private void compare() {
        if (!this.compared) {
            Node part = this.startPath.getNode(this.actualRoot);
            Context context = new Context(this.expectedRoot, part, this.startPath, this.startPath, this.configuration);
            if (part.isMissingNode()) {
                this.addDifference(context, "Missing node in path \"%s\".", this.startPath);
                this.reportDifference(DifferenceImpl.missing(context));
            } else {
                try {
                    this.compareNodes(context);
                }
                catch (FailedFastException failedFastException) {
                    // empty catch block
                }
            }
            this.compared = true;
            this.logDifferences();
        }
    }

    private void compareObjectNodes(Context context) {
        Set<String> actualKeys;
        Node expected = context.expectedNode();
        Node actual = context.actualNode();
        Path path = context.actualPath();
        Map<String, Node> expectedFields = Diff.getFields(expected);
        Map<String, Node> actualFields = Diff.getFields(actual);
        Set<String> expectedKeys = expectedFields.keySet();
        if (!expectedKeys.equals(actualKeys = actualFields.keySet())) {
            Set<String> missingKeys = Diff.getMissingKeys(expectedKeys, actualKeys);
            Set<String> extraKeys = this.removeNullExtraKeysWhereNeeded(actual, this.getExtraKeys(context.actualPath(), expectedKeys, actualKeys), context.actualPath());
            this.removePathsToBeIgnored(path, extraKeys);
            this.removePathsToBeIgnored(path, missingKeys);
            this.removeMissingIgnoredElements(expected, missingKeys);
            if (!missingKeys.isEmpty() || !extraKeys.isEmpty()) {
                for (String key : missingKeys) {
                    this.reportDifference(DifferenceImpl.missing(context.inField(key)));
                }
                for (String key : extraKeys) {
                    this.reportDifference(DifferenceImpl.extra(context.inField(key)));
                }
                String missingKeysMessage = Diff.getMissingKeysMessage(missingKeys, path);
                String extraKeysMessage = Diff.getExtraKeysMessage(extraKeys, path);
                this.addDifference(context, "Different keys found in node \"%s\"%s%s, " + this.differenceString(), path, missingKeysMessage, extraKeysMessage, this.normalize(expected), this.normalize(actual));
            }
        }
        for (String fieldName : this.commonFields(expectedFields, actualFields)) {
            this.compareNodes(context.inField(fieldName));
        }
    }

    private void removeMissingIgnoredElements(Node expected, Set<String> missingKeys) {
        missingKeys.removeIf(missingKey -> this.shouldIgnoreElement(expected.get((String)missingKey)));
    }

    private String normalize(Node node) {
        Map map = (Map)node.getValue();
        return JsonUtils.prettyPrint(new TreeMap<String, Object>(map));
    }

    private void removePathsToBeIgnored(Path path, Set<String> extraKeys) {
        if (!this.configuration.getPathsToBeIgnored().isEmpty()) {
            extraKeys.removeIf(key -> this.shouldIgnorePath(path.toField((String)key)));
        }
    }

    private Set<String> removeNullExtraKeysWhereNeeded(Node actual, Set<String> extraKeys, Path actualPath) {
        TreeSet<String> notNullExtraKeys = new TreeSet<String>();
        for (String extraKey : extraKeys) {
            if (this.hasOption(actualPath.toField(extraKey), Option.TREATING_NULL_AS_ABSENT) && actual.get(extraKey).isNull()) continue;
            notNullExtraKeys.add(extraKey);
        }
        return notNullExtraKeys;
    }

    private static String getMissingKeysMessage(Set<String> missingKeys, Path path) {
        if (!missingKeys.isEmpty()) {
            return ", missing: " + Diff.appendKeysToPrefix(missingKeys, path);
        }
        return "";
    }

    private static Set<String> getMissingKeys(Set<String> expectedKeys, Collection<String> actualKeys) {
        TreeSet<String> missingKeys = new TreeSet<String>(expectedKeys);
        missingKeys.removeAll(actualKeys);
        return missingKeys;
    }

    private static String getExtraKeysMessage(Set<String> extraKeys, Path path) {
        if (!extraKeys.isEmpty()) {
            return ", extra: " + Diff.appendKeysToPrefix(extraKeys, path);
        }
        return "";
    }

    private Set<String> getExtraKeys(Path path, Set<String> expectedKeys, Collection<String> actualKeys) {
        if (!this.hasOption(path, Option.IGNORING_EXTRA_FIELDS)) {
            TreeSet<String> extraKeys = new TreeSet<String>(actualKeys);
            extraKeys.removeAll(expectedKeys);
            return extraKeys;
        }
        return Collections.emptySet();
    }

    private boolean hasOption(Path path, Option option) {
        boolean hasOption = this.configuration.getOptions().contains((Object)option);
        if (this.specificPathOptions.containsKey((Object)option)) {
            for (PathOptionMatcher matcher : this.specificPathOptions.get((Object)option)) {
                if (!matcher.matches(path.getFullPath())) continue;
                hasOption = matcher.isAdded();
            }
        }
        return hasOption;
    }

    private static String appendKeysToPrefix(Iterable<String> keys, Path prefix) {
        Iterator<String> iterator = keys.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iterator.hasNext()) {
            String key = iterator.next();
            buffer.append("\"").append(prefix.toField(key)).append("\"");
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private void compareNodes(Context context) {
        if (this.shouldIgnorePath(context.actualPath())) {
            return;
        }
        Node expectedNode = context.expectedNode();
        Node actualNode = context.actualNode();
        Node.NodeType expectedNodeType = expectedNode.getNodeType();
        Node.NodeType actualNodeType = actualNode.getNodeType();
        Path fieldPath = context.actualPath();
        if (expectedNodeType == Node.NodeType.STRING && this.configuration.shouldIgnore(expectedNode.asText())) {
            return;
        }
        if (this.shouldIgnoreElement(expectedNode)) {
            return;
        }
        if (this.checkAny(Node.NodeType.NUMBER, ANY_NUMBER_PLACEHOLDER, "a number", context)) {
            return;
        }
        if (this.checkAny(Node.NodeType.BOOLEAN, ANY_BOOLEAN_PLACEHOLDER, "a boolean", context)) {
            return;
        }
        if (this.checkAny(Node.NodeType.STRING, ANY_STRING_PLACEHOLDER, "a string", context)) {
            return;
        }
        if (this.checkMatcher(context)) {
            return;
        }
        if (!expectedNodeType.equals(actualNodeType)) {
            this.addAndReportDifference(context, "Different value found in node \"%s\", " + this.differenceString() + ".", fieldPath, Diff.quoteTextValue(expectedNode), Diff.quoteTextValue(actualNode));
        } else {
            switch (expectedNodeType) {
                case OBJECT: {
                    this.compareObjectNodes(context);
                    break;
                }
                case ARRAY: {
                    this.compareArrayNodes(context);
                    break;
                }
                case STRING: {
                    this.compareStringValues(context);
                    break;
                }
                case NUMBER: {
                    BigDecimal actualValue = actualNode.decimalValue();
                    BigDecimal expectedValue = expectedNode.decimalValue();
                    if (this.hasOption(context.actualPath(), Option.IGNORING_VALUES)) break;
                    BigDecimal tolerance = this.configuration.getTolerance();
                    if (this.configuration.getNumberComparator().compare(expectedValue, actualValue, tolerance)) break;
                    BigDecimal diff = expectedValue.subtract(actualValue).abs();
                    List<Object> arguments = Arrays.asList(fieldPath, Diff.quoteTextValue(expectedValue), Diff.quoteTextValue(actualValue));
                    String message = "Different value found in node \"%s\", " + this.differenceString();
                    message = tolerance != null && tolerance.compareTo(BigDecimal.ZERO) != 0 ? message + ", difference is " + diff + ", tolerance is " + tolerance : message + ".";
                    this.addAndReportDifference(context, message, arguments.toArray());
                    break;
                }
                case BOOLEAN: {
                    this.compareValues(context, expectedNode.asBoolean(), actualNode.asBoolean());
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected node type " + expectedNodeType);
                }
            }
        }
    }

    private boolean shouldIgnoreElement(Node expectedNode) {
        return expectedNode.getNodeType() == Node.NodeType.STRING && "${json-unit.ignore-element}".equals(expectedNode.asText());
    }

    private boolean shouldIgnorePath(Path fieldPath) {
        return this.pathsToBeIgnored.matches(fieldPath.getFullPath());
    }

    private boolean checkMatcher(Context context) {
        Matcher patternMatcher;
        Node expectedNode = context.expectedNode();
        Node actualNode = context.actualNode();
        if (expectedNode.getNodeType() == Node.NodeType.STRING && (patternMatcher = MATCHER_PLACEHOLDER_PATTERN.matcher(expectedNode.asText())).matches()) {
            String matcherName = patternMatcher.group(1);
            new HamcrestHandler(this.configuration, this::addAndReportDifference, this::addDifference).matchHamcrestMatcher(context, actualNode, patternMatcher, matcherName);
            return true;
        }
        return false;
    }

    private boolean checkAny(Node.NodeType type, Pattern placeholder, String name, Context context) {
        Node expectedNode = context.expectedNode();
        Node actualNode = context.actualNode();
        if (expectedNode.getNodeType() == Node.NodeType.STRING && placeholder.matcher(expectedNode.asText()).matches()) {
            if (actualNode.getNodeType() == type) {
                return true;
            }
            this.addAndReportDifference(context, "Different value found in node \"%s\", " + this.differenceString() + ".", context.actualPath(), name, Diff.quoteTextValue(actualNode));
            return true;
        }
        return false;
    }

    private void compareStringValues(Context context) {
        String expectedValue = context.expectedNode().asText();
        String actualValue = context.actualNode().asText();
        Path path = context.actualPath();
        if (this.hasOption(context.actualPath(), Option.IGNORING_VALUES)) {
            return;
        }
        Matcher regexpMatcher = REGEX_PLACEHOLDER.matcher(expectedValue);
        if (regexpMatcher.matches()) {
            String pattern = regexpMatcher.group(1);
            if (!actualValue.matches(pattern)) {
                this.addAndReportDifference(context, "Different value found in node \"%s\". Pattern %s did not match %s.", path, Diff.quoteTextValue(pattern), Diff.quoteTextValue(actualValue));
            }
        } else {
            this.compareValues(context, expectedValue, actualValue);
        }
    }

    private void compareValues(Context context, Object expectedValue, Object actualValue) {
        if (!this.hasOption(context.actualPath(), Option.IGNORING_VALUES) && !expectedValue.equals(actualValue)) {
            this.addAndReportDifference(context, "Different value found in node \"%s\", " + this.differenceString() + ".", context.actualPath(), Diff.quoteTextValue(expectedValue), Diff.quoteTextValue(actualValue));
        }
    }

    private String differenceString() {
        return this.differenceString;
    }

    public static Object quoteTextValue(Object value) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private void compareArrayNodes(Context context) {
        block12: {
            int i;
            List<Node> actualElements;
            List<Node> expectedElements;
            Path path;
            Node actualNode;
            Node expectedNode;
            block10: {
                List<ArrayComparison.NodeWithIndex> missingValues;
                block13: {
                    List<ArrayComparison.NodeWithIndex> extraValues;
                    block11: {
                        expectedNode = context.expectedNode();
                        actualNode = context.actualNode();
                        path = context.actualPath();
                        expectedElements = this.asList(expectedNode.arrayElements());
                        actualElements = this.asList(actualNode.arrayElements());
                        if (this.failOnExtraArrayItems(context.actualPath())) {
                            if (expectedElements.size() != actualElements.size()) {
                                this.addDifference(context.length(expectedElements.size()), "Array \"%s\" has different length, expected: <%d> but was: <%d>.", path, expectedElements.size(), actualElements.size());
                            }
                        } else if (expectedElements.size() > actualElements.size()) {
                            this.addDifference(context.length("at least " + expectedElements.size()), "Array \"%s\" has invalid length, expected: <at least %d> but was: <%d>.", path, expectedElements.size(), actualElements.size());
                        }
                        if (!this.hasOption(context.actualPath(), Option.IGNORING_ARRAY_ORDER)) break block10;
                        ArrayComparison.ComparisonResult arrayComparison = this.compareArraysIgnoringOrder(expectedElements, actualElements, path);
                        missingValues = arrayComparison.getMissingValues();
                        extraValues = arrayComparison.getExtraValues();
                        if (expectedElements.size() != actualElements.size() || missingValues.size() != 1 || extraValues.size() != 1) break block11;
                        ArrayComparison.NodeWithIndex missing = missingValues.get(0);
                        ArrayComparison.NodeWithIndex extra = extraValues.get(0);
                        Path expectedPath = context.expectedPath().toElement(missing.index());
                        Path actualPath = context.actualPath().toElement(extra.index());
                        this.addDifference(context, "Different value found when comparing expected array element %s to actual element %s.", expectedPath, actualPath);
                        this.compareNodes(new Context(missing.node(), extra.node(), expectedPath, actualPath, this.configuration));
                        break block12;
                    }
                    if (!this.failOnExtraArrayItems(context.actualPath()) || missingValues.isEmpty() && extraValues.isEmpty()) break block13;
                    this.reportMissingValues(context, missingValues);
                    this.reportExtraValues(context, extraValues);
                    this.addDifference(context, "Array \"%s\" has different content. Missing values: %s, extra values: %s, expected: <%s> but was: <%s>", path, missingValues, extraValues, expectedNode, actualNode);
                    break block12;
                }
                if (missingValues.isEmpty()) break block12;
                this.reportMissingValues(context, missingValues);
                this.addDifference(context, "Array \"%s\" has different content. Missing values: %s, expected: <%s> but was: <%s>", path, missingValues, expectedNode, actualNode);
                break block12;
            }
            if (expectedElements.size() > actualElements.size()) {
                for (i = actualElements.size(); i < expectedElements.size(); ++i) {
                    this.reportDifference(DifferenceImpl.missing(context.toElement(i)));
                }
                this.addDifference(context, "Array \"%s\" has different content. Missing values: %s, expected: <%s> but was: <%s>", path, expectedElements.subList(actualElements.size(), expectedElements.size()), expectedNode, actualNode);
            } else if (this.failOnExtraArrayItems(context.actualPath()) && expectedElements.size() < actualElements.size()) {
                for (i = expectedElements.size(); i < actualElements.size(); ++i) {
                    this.reportDifference(DifferenceImpl.extra(context.toElement(i)));
                }
                this.addDifference(context, "Array \"%s\" has different content. Extra values: %s, expected: <%s> but was: <%s>", path, actualElements.subList(expectedElements.size(), actualElements.size()), expectedNode, actualNode);
            }
            for (i = 0; i < Math.min(expectedElements.size(), actualElements.size()); ++i) {
                this.compareNodes(context.toElement(i));
            }
        }
    }

    private ArrayComparison.ComparisonResult compareArraysIgnoringOrder(List<Node> expectedElements, List<Node> actualElements, Path path) {
        return new ArrayComparison(expectedElements, actualElements, path, this.configuration).compareArraysIgnoringOrder();
    }

    private boolean failOnExtraArrayItems(Path path) {
        return !this.hasOption(path, Option.IGNORING_EXTRA_ARRAY_ITEMS);
    }

    private List<Node> asList(Iterator<Node> elements) {
        ArrayList result = new ArrayList();
        elements.forEachRemaining(result::add);
        return Collections.unmodifiableList(result);
    }

    private void addDifference(Context context, String message, Object ... arguments) {
        this.differences.add(new JsonDifference(context, message, arguments));
        this.possiblyFailFast(context);
    }

    private void addAndReportDifference(Context context, String message, Object ... arguments) {
        this.addDifference(context, message, arguments);
        this.reportDifference(DifferenceImpl.different(context));
        this.possiblyFailFast(context);
    }

    private void reportDifference(Difference difference) {
        this.configuration.getDifferenceListener().diff(difference, DifferenceContextImpl.differenceContext(this.configuration, this.actualRoot, this.expectedRoot));
    }

    private void reportMissingValues(Context context, List<ArrayComparison.NodeWithIndex> missingValues) {
        for (ArrayComparison.NodeWithIndex missingValue : missingValues) {
            this.reportDifference(DifferenceImpl.missing(context.toElement(missingValue.index())));
        }
    }

    private void reportExtraValues(Context context, List<ArrayComparison.NodeWithIndex> extraValues) {
        for (ArrayComparison.NodeWithIndex extraValue : extraValues) {
            this.reportDifference(DifferenceImpl.extra(context.toElement(extraValue.index())));
        }
    }

    private void possiblyFailFast(Context context) {
        if (this.hasOption(context.actualPath(), Option.FAIL_FAST)) {
            throw new FailedFastException();
        }
    }

    private Set<String> commonFields(Map<String, Node> expectedFields, Map<String, Node> actualFields) {
        TreeSet<String> result = new TreeSet<String>(expectedFields.keySet());
        result.retainAll(actualFields.keySet());
        return Collections.unmodifiableSet(result);
    }

    public boolean similar() {
        this.compare();
        return this.differences.isEmpty();
    }

    private void logDifferences() {
        if (!this.differences.isEmpty()) {
            if (this.diffLogger.isEnabled()) {
                this.diffLogger.log(this.getDifferences().trim(), new Object[0]);
            }
            if (this.valuesLogger.isEnabled()) {
                this.valuesLogger.log("Comparing expected:\n{}\n------------\nwith actual:\n{}\n", this.expectedRoot, this.startPath.getNode(this.actualRoot));
            }
        }
    }

    private static Map<String, Node> getFields(Node node) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        Iterator<Node.KeyValue> fields = node.fields();
        while (fields.hasNext()) {
            Node.KeyValue field = fields.next();
            result.put(field.getKey(), field.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public String toString() {
        return this.differences();
    }

    public String differences() {
        if (this.similar()) {
            return "JSON documents have the same value.";
        }
        return this.getDifferences();
    }

    private String getDifferences() {
        return ExceptionUtils.formatDifferences("", this.differences);
    }

    public void failIfDifferent() {
        this.failIfDifferent(null);
    }

    public void failIfDifferent(String message) {
        if (!this.similar()) {
            if (!this.configuration.getOptions().contains((Object)Option.REPORTING_DIFFERENCE_AS_NORMALIZED_STRING) || this.actualRoot.isMissingNode()) {
                throw ExceptionUtils.createException(message, this.differences);
            }
            String normalizedExpected = Normalizer.toNormalizedString(this.expectedRoot, Node.MISSING_NODE);
            String normalizedActual = Normalizer.toNormalizedString(this.actualRoot, this.expectedRoot);
            throw new AssertionFailedError("JSON documents are different: expected <" + normalizedExpected + ">but was <" + normalizedActual + ">", (Object)normalizedExpected, (Object)normalizedActual);
        }
    }

    private static JsonUnitLogger createLogger(String name) {
        if (ClassUtils.isClassPresent("org.slf4j.Logger")) {
            return new JsonUnitLogger.SLF4JLogger(name);
        }
        return JsonUnitLogger.NULL_LOGGER;
    }

    private static final class FailedFastException
    extends RuntimeException {
        private FailedFastException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

