/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator.ops;

import net.hasor.dataql.Hints;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.operator.OperatorProcess;
import net.hasor.utils.StringUtils;

abstract class AbstractDOP
implements OperatorProcess {
    AbstractDOP() {
    }

    @Override
    public Object doProcess(String operator, Object[] args, Hints option) throws InstructRuntimeException {
        if (args == null) {
            throw new InstructRuntimeException("dyadic operator error, args is null.");
        }
        if (args.length != 2) {
            throw new InstructRuntimeException("dyadic operator error, args count expect 2 , but " + args.length);
        }
        if (!this.testIn(new String[]{"+", "-", "*", "/", "%", "\\", ">", ">=", "<", "<=", "==", "!=", "&", "|", "^", "<<", ">>", ">>>", "||", "&&"}, operator)) {
            throw new InstructRuntimeException("does not support dyadic Operator -> " + operator);
        }
        return this.doDyadicProcess(operator, args[0], args[1], option);
    }

    protected static InstructRuntimeException throwError(String operator, Object realFstObject, Object realSecObject, String message) {
        String fstDataType = realFstObject == null ? "null" : realFstObject.getClass().getName();
        String secDataType = realSecObject == null ? "null" : realSecObject.getClass().getName();
        message = StringUtils.isBlank((String)message) ? "no message." : message;
        return new InstructRuntimeException(fstDataType + " and " + secDataType + " , Cannot be used as '" + operator + "' -> " + message);
    }

    public abstract Object doDyadicProcess(String var1, Object var2, Object var3, Hints var4) throws InstructRuntimeException;
}

