/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.mem;

import java.util.Map;
import net.hasor.dataql.Finder;
import net.hasor.dataql.Hints;
import net.hasor.dataql.Udf;
import net.hasor.dataql.UdfSource;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.utils.ExceptionUtils;

public class RefCall {
    private boolean autoUnwrap;
    private Udf refCall;

    public RefCall(boolean autoUnwrap, Udf refCall) {
        this.autoUnwrap = autoUnwrap;
        this.refCall = refCall;
    }

    public Object invokeMethod(Object[] paramArrays, Hints optionSet, Finder finder) throws InstructRuntimeException {
        try {
            Map<String, Udf> result;
            Object[] objects = (Object[])paramArrays.clone();
            if (this.autoUnwrap) {
                for (int i = 0; i < objects.length; ++i) {
                    if (!(objects[i] instanceof DataModel)) continue;
                    objects[i] = ((DataModel)objects[i]).unwrap();
                }
            }
            if ((result = this.refCall.call(optionSet, objects)) instanceof UdfSource) {
                result = ((UdfSource)((Object)result)).getUdfResource(finder).get();
            }
            return DomainHelper.convertTo(result);
        }
        catch (Throwable e) {
            if (e instanceof InstructRuntimeException) {
                throw (InstructRuntimeException)e;
            }
            throw ExceptionUtils.toRuntimeException((Throwable)e, throwable -> new InstructRuntimeException(throwable.getMessage(), (Throwable)throwable));
        }
    }
}

