/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.mem;

public class DataHeap
implements Cloneable {
    private DataHeap parent = null;
    private int depth = 0;
    private Object[] heapDataPool = new Object[10];
    private String[] heapDataNames = new String[10];

    public DataHeap() {
        this(null);
    }

    public DataHeap(DataHeap parent) {
        if (parent != null) {
            this.parent = parent;
            this.depth = parent.depth + 1;
        }
    }

    public void defineName(int position, String name) {
        if (position >= this.heapDataNames.length) {
            String[] newHeapDataPool = new String[this.heapDataNames.length + 5];
            System.arraycopy(this.heapDataNames, 0, newHeapDataPool, 0, this.heapDataNames.length);
            this.heapDataNames = newHeapDataPool;
        }
        this.heapDataNames[position] = name;
    }

    public void saveData(int position, Object data) {
        if (position >= this.heapDataPool.length) {
            Object[] newHeapDataPool = new Object[this.heapDataPool.length + 5];
            System.arraycopy(this.heapDataPool, 0, newHeapDataPool, 0, this.heapDataPool.length);
            this.heapDataPool = newHeapDataPool;
        }
        this.heapDataPool[position] = data;
    }

    public Object loadData(int depth, int position) {
        DataHeap heapData = this;
        for (int i = 0; i <= depth; ++i) {
            if (i == depth) {
                return heapData.heapDataPool[position];
            }
            heapData = heapData.parent;
            if (heapData == null) break;
        }
        return null;
    }

    public DataHeap clone() {
        DataHeap parent = null;
        if (this.parent != null) {
            parent = this.parent.clone();
        }
        DataHeap dataHeap = new DataHeap(parent);
        dataHeap.depth = this.depth;
        dataHeap.heapDataPool = (Object[])this.heapDataPool.clone();
        return dataHeap;
    }
}

