/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.domain;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.runtime.operator.OperatorUtils;
import net.hasor.utils.NumberUtils;

public class ValueModel
implements DataModel {
    public static ValueModel NULL = new ValueModel(null);
    public static ValueModel TRUE = new ValueModel(true);
    public static ValueModel FALSE = new ValueModel(false);
    private Object value = null;

    ValueModel(Object value) {
        this.value = value;
    }

    @Override
    public Object asOri() {
        return this.value;
    }

    @Override
    public Object unwrap() {
        return this.value;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isNumber() {
        return OperatorUtils.isNumber(this.value);
    }

    public boolean isByte() {
        return OperatorUtils.isByteNumber(this.value);
    }

    public boolean isShort() {
        return OperatorUtils.isShortNumber(this.value);
    }

    public boolean isInt() {
        return OperatorUtils.isIntegerNumber(this.value);
    }

    public boolean isLong() {
        return OperatorUtils.isLongNumber(this.value);
    }

    public boolean isBigInteger() {
        return this.value instanceof BigInteger;
    }

    public boolean isFloat() {
        return OperatorUtils.isFloatNumber(this.value);
    }

    public boolean isDouble() {
        return OperatorUtils.isDoubleNumber(this.value);
    }

    public boolean isBigDecimal() {
        return this.value instanceof BigDecimal;
    }

    public boolean isDecimal() {
        return this.isFloat() || this.isDouble() || this.isBigDecimal();
    }

    public boolean isBoolean() {
        return OperatorUtils.isBoolean(this.value);
    }

    public boolean asBoolean() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue() != 0;
        }
        if (this.value instanceof String) {
            String strVal = (String)this.value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return false;
            }
            if ("true".equalsIgnoreCase(strVal) || "1".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(strVal) || "0".equals(strVal)) {
                return Boolean.FALSE;
            }
        }
        throw new ClassCastException("can not cast to boolean, value : " + this.value);
    }

    public Number asNumber() {
        if (this.value == null) {
            return 0;
        }
        return (Number)this.value;
    }

    public byte asByte() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        if (this.value instanceof String) {
            String strVal = (String)this.value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return 0;
            }
            if (NumberUtils.isNumber((String)strVal)) {
                return Byte.parseByte(strVal);
            }
        }
        if (this.value instanceof Boolean) {
            return (byte)((Boolean)this.value != false ? 1 : 0);
        }
        throw new ClassCastException("can not cast to byte, value : " + this.value);
    }

    public short asShort() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        if (this.value instanceof String) {
            String strVal = (String)this.value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return 0;
            }
            if (NumberUtils.isNumber((String)strVal)) {
                return Short.parseShort(strVal);
            }
        }
        if (this.value instanceof Boolean) {
            return (short)((Boolean)this.value != false ? 1 : 0);
        }
        throw new ClassCastException("can not cast to short, value : " + this.value);
    }

    public int asInt() {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        if (this.value instanceof String) {
            String strVal = (String)this.value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return 0;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            if (NumberUtils.isNumber((String)strVal)) {
                return Integer.parseInt(strVal);
            }
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1 : 0;
        }
        throw new ClassCastException("can not cast to int, value : " + this.value);
    }

    public long asLong() {
        if (this.value == null) {
            return 0L;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        if (this.value instanceof String) {
            String strVal = (String)this.value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return 0L;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            if (NumberUtils.isNumber((String)strVal)) {
                return Long.parseLong(strVal);
            }
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1L : 0L;
        }
        throw new ClassCastException("can not cast to long, value : " + this.value);
    }

    public BigInteger asBigInteger() {
        if (this.value == null) {
            return BigInteger.ZERO;
        }
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        if (this.value instanceof Float || this.value instanceof Double) {
            return BigInteger.valueOf(((Number)this.value).longValue());
        }
        String strVal = this.value.toString();
        if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
            return BigInteger.ZERO;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        try {
            return new BigInteger(strVal);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException("can not cast to BigInteger, value : " + this.value);
        }
    }

    public float asFloat() {
        if (this.value == null) {
            return 0.0f;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        if (this.value instanceof String) {
            String strVal = this.value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return 0.0f;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            if (NumberUtils.isNumber((String)strVal)) {
                return Float.parseFloat(strVal);
            }
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1.0f : 0.0f;
        }
        throw new ClassCastException("can not cast to float, value : " + this.value);
    }

    public double asDouble() {
        if (this.value == null) {
            return 0.0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        if (this.value instanceof String) {
            String strVal = this.value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return 0.0;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            if (NumberUtils.isNumber((String)strVal)) {
                return Double.parseDouble(strVal);
            }
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1.0 : 0.0;
        }
        throw new ClassCastException("can not cast to double, value : " + this.value);
    }

    public BigDecimal asBigDecimal() {
        if (this.value == null) {
            return BigDecimal.ZERO;
        }
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.value);
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String strVal = this.value.toString();
        if (strVal.length() == 0) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(strVal);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException("can not cast to BigDecimal, value : " + this.value);
        }
    }

    public boolean isString() {
        return this.value instanceof CharSequence;
    }

    public String asString() {
        return this.value == null ? null : this.value.toString();
    }
}

