/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.domain;

import java.util.LinkedHashMap;
import java.util.Map;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.DomainHelper;
import net.hasor.dataql.domain.ListModel;
import net.hasor.dataql.domain.UdfModel;
import net.hasor.dataql.domain.ValueModel;

public class ObjectModel
implements DataModel {
    private Map<String, DataModel> dataModel = new LinkedHashMap<String, DataModel>();

    public void put(String key, Object value) {
        this.dataModel.put(key, DomainHelper.convertTo(value));
    }

    public <K, V> void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey().toString(), e.getValue());
        }
    }

    public int size() {
        return this.dataModel.size();
    }

    @Override
    public Map<String, DataModel> asOri() {
        return this.dataModel;
    }

    @Override
    public Map<String, Object> unwrap() {
        LinkedHashMap<String, Object> unwrap = new LinkedHashMap<String, Object>(this.dataModel.size());
        this.dataModel.forEach((key, dataModel) -> unwrap.put((String)key, dataModel.unwrap()));
        return unwrap;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    public DataModel get(String fieldName) {
        return this.dataModel.get(fieldName);
    }

    public boolean isValue(String fieldName) {
        return this.dataModel.get(fieldName) instanceof ValueModel;
    }

    public ValueModel getValue(String fieldName) {
        DataModel dataItem = this.dataModel.get(fieldName);
        if (dataItem instanceof ValueModel) {
            return (ValueModel)dataItem;
        }
        if (dataItem == null) {
            return null;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to ValueModel.");
    }

    public boolean isList(String fieldName) {
        return this.dataModel.get(fieldName) instanceof ListModel;
    }

    public ListModel getList(String fieldName) {
        DataModel dataItem = this.dataModel.get(fieldName);
        if (dataItem instanceof ListModel) {
            return (ListModel)dataItem;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to ListModel.");
    }

    public boolean isObject(String fieldName) {
        return this.dataModel.get(fieldName) instanceof ObjectModel;
    }

    public ObjectModel getObject(String fieldName) {
        DataModel dataItem = this.dataModel.get(fieldName);
        if (dataItem instanceof ObjectModel) {
            return (ObjectModel)dataItem;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to ObjectModel.");
    }

    public boolean isUdf(String fieldName) {
        return this.dataModel.get(fieldName) instanceof UdfModel;
    }

    public UdfModel getUdf(String fieldName) {
        DataModel dataItem = this.dataModel.get(fieldName);
        if (dataItem instanceof UdfModel) {
            return (UdfModel)dataItem;
        }
        throw new ClassCastException(dataItem.getClass() + " not Cast to UdfModel.");
    }
}

