/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.qil;

import java.util.Collections;
import java.util.Map;
import net.hasor.dataql.compiler.qil.Instruction;
import net.hasor.utils.StringUtils;

public class QIL {
    private Instruction[][] queueSet;
    private Map<String, Integer> compilerVar;

    public QIL(Instruction[][] queueSet, Map<String, Integer> compilerVar) {
        this.queueSet = queueSet;
        this.compilerVar = compilerVar;
    }

    public Map<String, Integer> getCompilerVar() {
        return Collections.unmodifiableMap(this.compilerVar);
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder();
        for (int i = 0; i < this.queueSet.length; ++i) {
            Instruction[] instList = this.queueSet[i];
            QIL.printInstList(i, instList, strBuffer);
        }
        return strBuffer.toString();
    }

    private static void printInstList(int name, Instruction[] instList, StringBuilder strBuffer) {
        strBuffer.append("[");
        strBuffer.append(name);
        strBuffer.append("]\n");
        int length = String.valueOf(instList.length).length();
        for (int i = 0; i < instList.length; ++i) {
            Instruction inst = instList[i];
            strBuffer.append("  #");
            strBuffer.append(StringUtils.leftPad((String)String.valueOf(i), (int)length, (char)'0'));
            strBuffer.append("  ");
            strBuffer.append(inst.toString());
            strBuffer.append("\n");
        }
        strBuffer.append("\n");
    }

    public int iqlPoolSize() {
        return this.queueSet.length;
    }

    public int iqlSize(int address) {
        return this.queueSet[address].length;
    }

    public Instruction instOf(int address, int index) {
        return this.queueSet[address][index];
    }

    public Instruction[] iqlArrays(int address) {
        return (Instruction[])this.queueSet[address].clone();
    }
}

