/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.RouteVariable;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.value.EnterRouteVariable;
import net.hasor.utils.StringUtils;

public class NameRouteVariable
implements Variable,
RouteVariable {
    private RouteVariable parent;
    private String name;

    public NameRouteVariable(RouteVariable parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public RouteVariable getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        if (this.parent != null) {
            this.parent.accept(astVisitor);
        }
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        EnterRouteVariable.RouteType routeType = null;
        EnterRouteVariable.SpecialType specialType = EnterRouteVariable.SpecialType.Special_A;
        if (this.parent instanceof EnterRouteVariable) {
            routeType = ((EnterRouteVariable)this.parent).getRouteType();
            specialType = ((EnterRouteVariable)this.parent).getSpecialType();
            if (specialType == null) {
                specialType = EnterRouteVariable.SpecialType.Special_A;
            }
        }
        if (EnterRouteVariable.RouteType.Params == routeType) {
            writer.write(specialType.getCode() + "{");
        }
        this.parent.doFormat(depth, formatOption, writer);
        if (this.parent instanceof EnterRouteVariable) {
            if (StringUtils.isBlank((String)this.name)) {
                EnterRouteVariable.SpecialType special = ((EnterRouteVariable)this.parent).getSpecialType();
                if (special != EnterRouteVariable.SpecialType.Special_A) {
                    writer.write(((EnterRouteVariable)this.parent).getSpecialType().getCode());
                }
            } else {
                if (EnterRouteVariable.RouteType.Params != routeType && EnterRouteVariable.SpecialType.Special_A != specialType) {
                    writer.write(specialType.getCode());
                }
                writer.write(this.name);
            }
        } else if (this.parent instanceof NameRouteVariable && StringUtils.isBlank((String)((NameRouteVariable)this.parent).name)) {
            writer.write(this.name);
        } else {
            writer.write("." + this.name);
        }
        if (EnterRouteVariable.RouteType.Params == routeType) {
            writer.write("}");
        }
    }
}

