/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.utils.StringUtils;

public class VarInst
implements Inst {
    private String varName;
    private Variable value;

    public VarInst(String varName, Variable value) {
        this.varName = varName;
        this.value = value;
    }

    public String getVarName() {
        return this.varName;
    }

    public Variable getValue() {
        return this.value;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                VarInst.this.value.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        writer.write(fixedString + String.format("var %s = ", this.varName));
        this.value.doFormat(depth, formatOption, writer);
        writer.write(";\n");
    }
}

