/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.utils.StringUtils;

public class ReturnInst
implements Inst {
    private int returnCode;
    private Variable resultData;

    public ReturnInst(int returnCode, Variable resultData) {
        this.returnCode = returnCode;
        this.resultData = resultData;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public Variable getResultData() {
        return this.resultData;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                ReturnInst.this.resultData.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        if (this.returnCode != 0) {
            writer.write(fixedString + String.format("return %s, ", this.returnCode));
        } else {
            writer.write(fixedString + "return ");
        }
        this.resultData.doFormat(depth + 1, formatOption, writer);
        writer.write(";\n");
    }
}

