/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.value.PrimitiveVariable;

public class HintInst
implements Inst {
    private String hint;
    private PrimitiveVariable value;

    public HintInst(String hint, PrimitiveVariable value) {
        this.hint = hint;
        this.value = value;
    }

    public String getHint() {
        return this.hint;
    }

    public PrimitiveVariable getValue() {
        return this.value;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                HintInst.this.value.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String opt = "hint " + this.hint + " = ";
        writer.write(opt);
        this.value.doFormat(depth + 1, formatOption, writer);
        writer.write(";\n");
    }
}

