/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql;

import java.io.IOException;
import java.io.InputStream;
import net.hasor.dataql.FragmentProcess;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.ResourcesUtils;

public interface Finder {
    public static final Finder DEFAULT = new Finder(){};

    default public InputStream findResource(String resourceName) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = ResourcesUtils.getResourceAsStream((String)resourceName);
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e, throwable -> new RuntimeException("import compiler failed -> '" + resourceName + "' not found.", (Throwable)throwable));
        }
        return inputStream;
    }

    default public Object findBean(Class<?> beanType) {
        try {
            return beanType.newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e, throwable -> new RuntimeException("load Bean failed -> '" + beanType.getName(), (Throwable)throwable));
        }
    }

    default public FragmentProcess findFragmentProcess(String fragmentType) {
        throw new RuntimeException(fragmentType + " fragment undefine.");
    }
}

