/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.asm.AnnotationVisitor;
import net.hasor.utils.asm.ClassReader;
import net.hasor.utils.asm.ClassVisitor;

public class ScanClassPath {
    private ClassLoader classLoader = null;
    private String[] scanPackages = null;
    private Map<Class<?>, Set<Class<?>>> cacheMap = new WeakHashMap();
    private Map<String, ClassInfo> classInfoMap = new ConcurrentHashMap<String, ClassInfo>();

    private ScanClassPath(String[] scanPackages) {
        this(scanPackages, (ClassLoader)null);
    }

    private ScanClassPath(String[] scanPackages, ClassLoader classLoader) {
        this.scanPackages = scanPackages;
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
    }

    public static ScanClassPath newInstance(String[] scanPackages) {
        return new ScanClassPath(scanPackages){};
    }

    public static ScanClassPath newInstance(String scanPackages) {
        return new ScanClassPath(new String[]{scanPackages}){};
    }

    public static Set<Class<?>> getClassSet(String packagePath, Class<?> compareType) {
        return ScanClassPath.getClassSet(new String[]{packagePath}, compareType);
    }

    public static Set<Class<?>> getClassSet(String[] loadPackages, Class<?> featureType) {
        return ScanClassPath.newInstance(loadPackages).getClassSet(featureType);
    }

    public Set<Class<?>> getClassSet(Class<?> compareType) {
        Set<Class<?>> returnData = this.cacheMap.get(compareType);
        if (returnData != null) {
            return Collections.unmodifiableSet(returnData);
        }
        String compareTypeStr = compareType.getName();
        HashSet classStrSet = new HashSet();
        for (String tiem : this.scanPackages) {
            if (StringUtils.isBlank(tiem)) continue;
            try {
                ResourcesUtils.scan(tiem.replace(".", "/") + "*.class", (event, isInJar) -> {
                    String name = event.getName();
                    if (!name.endsWith(".class")) {
                        return;
                    }
                    name = name.substring(0, name.length() - ".class".length());
                    name = name.replace("/", ".");
                    ClassInfo info = null;
                    try (InputStream inStream = event.getStream();){
                        info = this.loadClassInfo(name, inStream, this.classLoader);
                    }
                    for (String castType : info.castType) {
                        if (!castType.equals(compareTypeStr)) continue;
                        classStrSet.add(name);
                        return;
                    }
                    for (String face : info.annos) {
                        if (!face.equals(compareTypeStr)) continue;
                        classStrSet.add(name);
                        return;
                    }
                });
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        returnData = new HashSet();
        for (String atClass : classStrSet) {
            try {
                Class<?> clazz = Class.forName(atClass, false, this.classLoader);
                returnData.add(clazz);
            }
            catch (Throwable throwable) {}
        }
        this.cacheMap.put(compareType, returnData);
        return returnData;
    }

    private ClassInfo loadClassInfo(String className, InputStream inStream, ClassLoader loader) throws IOException {
        if (this.classInfoMap.containsKey(className)) {
            return this.classInfoMap.get(className);
        }
        ClassReader classReader = null;
        try {
            classReader = new ClassReader(inStream);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        final ClassInfo info = new ClassInfo();
        classReader.accept(new ClassVisitor(458752){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                info.className = name.replace('/', '.');
                if (superName != null) {
                    info.superName = superName.replace('/', '.');
                }
                info.interFaces = interfaces;
                for (int i = 0; i < info.interFaces.length; ++i) {
                    info.interFaces[i] = info.interFaces[i].replace('/', '.');
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                String[] annoArrays = info.annos == null ? new String[]{} : info.annos;
                String[] newAnnoArrays = new String[annoArrays.length + 1];
                System.arraycopy(annoArrays, 0, newAnnoArrays, 0, annoArrays.length);
                String annnoType = desc.substring(1, desc.length() - 1);
                newAnnoArrays[newAnnoArrays.length - 1] = annnoType.replace('/', '.');
                info.annos = newAnnoArrays;
                return super.visitAnnotation(desc, visible);
            }
        }, 1);
        if (info.superName != null) {
            try (InputStream superStream = loader.getResourceAsStream(info.superName.replace('.', '/') + ".class");){
                if (superStream != null) {
                    this.loadClassInfo(info.superName, superStream, loader);
                }
            }
        }
        for (String faces : info.interFaces) {
            try (InputStream superStream = loader.getResourceAsStream(faces.replace('.', '/') + ".class");){
                if (superStream == null) continue;
                this.loadClassInfo(faces, superStream, loader);
            }
        }
        TreeSet<String> castTypeList = new TreeSet<String>();
        String superName = info.superName;
        this.addCastTypeList(info, castTypeList);
        if (superName != null) {
            while (superName != null && this.classInfoMap.containsKey(superName)) {
                ClassInfo superInfo = this.classInfoMap.get(superName);
                this.addCastTypeList(superInfo, castTypeList);
                superName = superInfo.superName;
            }
        }
        info.castType = castTypeList.toArray(new String[0]);
        this.classInfoMap.put(info.className, info);
        return info;
    }

    private void addCastTypeList(ClassInfo info, Set<String> addTo) {
        if (info == null) {
            return;
        }
        addTo.add(info.className);
        if (info.superName != null) {
            addTo.add(info.superName);
        }
        if (info.interFaces != null) {
            for (String atFaces : info.interFaces) {
                addTo.add(atFaces);
                this.addCastTypeList(this.classInfoMap.get(atFaces), addTo);
            }
        }
    }

    private static class ClassInfo {
        public String className = null;
        public String superName = null;
        public String[] interFaces = new String[0];
        public String[] castType = new String[0];
        public String[] annos = new String[0];

        private ClassInfo() {
        }
    }
}

