/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.hasor.utils.MatchUtils;
import net.hasor.utils.io.AutoCloseInputStream;

public abstract class ResourcesUtils {
    public static String formatResource(String resourcePath) {
        if (resourcePath != null && resourcePath.length() > 1 && resourcePath.charAt(0) == '/') {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    private static ClassLoader getCurrentLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Map<String, String> getPropertys(String[] resourcePaths) throws IOException {
        return ResourcesUtils.getPropertys(Arrays.asList(resourcePaths).iterator());
    }

    public static Map<String, String> getPropertys(Iterator<String> iterator) throws IOException {
        if (iterator == null) {
            return null;
        }
        HashMap<String, String> fullData = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String str = iterator.next();
            Map<String, String> att = ResourcesUtils.getPropertys(str);
            if (att == null) continue;
            fullData.putAll(att);
        }
        return fullData;
    }

    public static Map<String, String> getPropertys(String resourcePath) throws IOException {
        Properties prop = new Properties();
        InputStream in = ResourcesUtils.getResourceAsStream(ResourcesUtils.formatResource(resourcePath));
        if (in != null) {
            prop.load(in);
        }
        HashMap<String, String> resultData = new HashMap<String, String>();
        for (Object keyObj : prop.keySet()) {
            String key = (String)keyObj;
            String val = prop.getProperty(key);
            resultData.put(key, val);
        }
        return resultData;
    }

    public static URL getResource(String resourcePath) throws IOException {
        if (resourcePath == null) {
            return null;
        }
        resourcePath = ResourcesUtils.formatResource(resourcePath);
        URL url = ResourcesUtils.getCurrentLoader().getResource(resourcePath);
        return url;
    }

    public static List<URL> getResources(String resourcePath) throws IOException {
        if (resourcePath == null) {
            return new ArrayList<URL>(0);
        }
        resourcePath = ResourcesUtils.formatResource(resourcePath);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> eurls = ResourcesUtils.getCurrentLoader().getResources(resourcePath);
        while (eurls.hasMoreElements()) {
            URL url = eurls.nextElement();
            urls.add(url);
        }
        return urls;
    }

    public static InputStream getResourceAsStream(File resourceFile) throws IOException {
        return ResourcesUtils.getResourceAsStream(resourceFile.toURI().toURL());
    }

    public static InputStream getResourceAsStream(URI resourceURI) throws IOException {
        return ResourcesUtils.getResourceAsStream(resourceURI.toURL());
    }

    public static InputStream getResourceAsStream(URL resourceURL) throws IOException {
        String protocol = resourceURL.getProtocol();
        File path = new File(URLDecoder.decode(resourceURL.getFile(), "utf-8"));
        if (protocol.equals("file")) {
            if (path.canRead() && path.isFile()) {
                return new AutoCloseInputStream(new FileInputStream(path));
            }
        } else {
            if (protocol.equals("jar")) {
                JarFile jar = ((JarURLConnection)resourceURL.openConnection()).getJarFile();
                String jarFile = jar.getName().replace("\\", "/");
                String resourcePath = URLDecoder.decode(resourceURL.getPath(), "utf-8");
                int beginIndex = resourcePath.indexOf(jarFile) + jarFile.length();
                String entPath = resourcePath.substring(beginIndex + 2);
                ZipEntry e = jar.getEntry(entPath);
                return jar.getInputStream(e);
            }
            if (protocol.equals("classpath")) {
                String resourcePath = ResourcesUtils.formatResource(resourceURL.getPath());
                return ResourcesUtils.getResourceAsStream(resourcePath);
            }
        }
        return null;
    }

    public static InputStream getResourceAsStream(String resourcePath) throws IOException {
        resourcePath = ResourcesUtils.formatResource(resourcePath);
        InputStream inStream = ResourcesUtils.getCurrentLoader().getResourceAsStream(resourcePath);
        if (inStream == null) {
            inStream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourcePath);
        }
        return inStream;
    }

    public static List<InputStream> getResourcesAsStream(String resourcePath) throws IOException {
        ArrayList<InputStream> iss = new ArrayList<InputStream>();
        List<URL> urls = ResourcesUtils.getResources(resourcePath);
        for (URL url : urls) {
            InputStream in = ResourcesUtils.getResourceAsStream(url);
            if (in == null) continue;
            iss.add(in);
        }
        return iss;
    }

    private static void scanDir(File dirFile, String wild, Scanner item, File contextDir) throws IOException {
        String contextPath = contextDir.getAbsolutePath().replace("\\", "/");
        if (!dirFile.isDirectory()) {
            String dirPath = dirFile.getAbsolutePath().replace("\\", "/");
            if (dirPath.startsWith(contextPath)) {
                dirPath = dirPath.substring(contextPath.length());
            }
            if (!MatchUtils.matchWild(wild, dirPath)) {
                return;
            }
            item.found(new ScanEvent(dirPath, dirFile), false);
            return;
        }
        File[] files = dirFile.listFiles();
        for (File f : files = files == null ? new File[]{} : files) {
            String dirPath = f.getAbsolutePath().replace("\\", "/");
            if (dirPath.startsWith(contextPath)) {
                dirPath = dirPath.substring(contextPath.length() + 1);
            }
            if (f.isDirectory()) {
                ResourcesUtils.scanDir(f, wild, item, contextDir);
            }
            if (!MatchUtils.matchWild(wild, dirPath)) continue;
            item.found(new ScanEvent(dirPath, f), false);
        }
    }

    public static void scanJar(JarFile jarFile, String wild, Scanner item) throws IOException {
        Enumeration<JarEntry> jes = jarFile.entries();
        while (jes.hasMoreElements()) {
            JarEntry e = jes.nextElement();
            String name = e.getName();
            if (!MatchUtils.matchWild(wild, name) || e.isDirectory()) continue;
            InputStream jarFileInputStream = jarFile.getInputStream(e);
            Throwable throwable = null;
            try {
                item.found(new ScanEvent(name, e, jarFileInputStream), true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFileInputStream == null) continue;
                if (throwable != null) {
                    try {
                        jarFileInputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jarFileInputStream.close();
            }
        }
    }

    public static void scan(String wild, Scanner item) throws IOException, URISyntaxException {
        if (wild == null || wild.equals("")) {
            return;
        }
        char firstChar = wild.charAt(0);
        if (firstChar == '?' || firstChar == '*') {
            throw new IllegalArgumentException("classpath\u5305\u626b\u63cf\u4e0d\u652f\u6301\u9996\u4e2a\u5b57\u6bcd\u4e3a\u901a\u914d\u7b26\u5b57\u7b26\u3002");
        }
        int index1 = wild.indexOf(63);
        int index2 = wild.indexOf(42);
        int index = (index1 = index1 == -1 ? (index1 = wild.length()) : index1) > (index2 = index2 == -1 ? (index2 = wild.length()) : index2) ? index2 : index1;
        String _wild = wild.substring(0, index);
        if (_wild.charAt(_wild.length() - 1) == '/') {
            _wild = _wild.substring(0, _wild.length() - 1);
        }
        Enumeration<URL> urls = ResourcesUtils.findAllClassPath(_wild);
        List<URL> dirs = ResourcesUtils.rootDir();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                File f = new File(url.toURI());
                ResourcesUtils.scanDir(f, wild, item, new File(ResourcesUtils.has(dirs, url).toURI()));
                continue;
            }
            if (!protocol.equals("jar")) continue;
            JarURLConnection urlc = (JarURLConnection)url.openConnection();
            ResourcesUtils.scanJar(urlc.getJarFile(), wild, item);
        }
    }

    private static URL has(List<URL> dirs, URL one) {
        for (URL u : dirs) {
            if (!one.toString().startsWith(u.toString())) continue;
            return u;
        }
        return null;
    }

    private static List<URL> rootDir() throws IOException {
        Enumeration<URL> roote = ResourcesUtils.findAllClassPath("");
        ArrayList<URL> rootList = new ArrayList<URL>();
        while (roote.hasMoreElements()) {
            rootList.add(roote.nextElement());
        }
        return rootList;
    }

    public static Enumeration<URL> findAllClassPath(String name) throws IOException {
        ClassLoader loader = ResourcesUtils.getCurrentLoader();
        return loader.getResources(name);
    }

    public static interface Scanner {
        public void found(ScanEvent var1, boolean var2) throws IOException;
    }

    public static class ScanEvent {
        private String name = null;
        private boolean isRead = false;
        private boolean isWrite = false;
        private InputStream stream = null;
        private File file = null;

        ScanEvent(String name, File file) {
            this.isRead = file.canRead();
            this.isWrite = file.canWrite();
            this.file = file;
            this.name = name;
        }

        ScanEvent(String name, JarEntry entry, InputStream stream) {
            this.isRead = !entry.isDirectory();
            this.isWrite = false;
            this.stream = stream;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRead() {
            return this.isRead;
        }

        public boolean isWrite() {
            return this.isWrite;
        }

        public InputStream getStream() throws FileNotFoundException {
            if (this.stream != null) {
                return this.stream;
            }
            if (this.file != null && this.isRead) {
                return new AutoCloseInputStream(new FileInputStream(this.file));
            }
            return null;
        }
    }
}

