/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskEntry;
import org.tio.utils.timer.TimerTaskList;
import org.tio.utils.timer.TimingWheel;

public class SystemTimer
implements Timer,
Consumer<TimerTaskEntry> {
    private static final Logger logger = LoggerFactory.getLogger(SystemTimer.class);
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue = new DelayQueue();
    private final LongAdder taskCounter = new LongAdder();
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public SystemTimer() {
        this("SystemTimerExecutor");
    }

    public SystemTimer(String executeName) {
        this(1L, 20, executeName);
    }

    public SystemTimer(long tickMs, int wheelSize, String executeName) {
        this(tickMs, wheelSize, Timer.getHiresClockMs(), executeName);
    }

    public SystemTimer(long tickMs, int wheelSize, long startMs, String executeName) {
        this.taskExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), r -> new Thread(r, executeName));
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskEntry(timerTask, timerTask.getDelayMs() + Timer.getHiresClockMs()));
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket;
        try {
            bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        if (bucket == null) {
            return false;
        }
        this.writeLock.lock();
        try {
            while (bucket != null) {
                this.timingWheel.advanceClock(bucket.getExpiration());
                bucket.flush(this);
                bucket = (TimerTaskList)this.delayQueue.poll();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public long size() {
        return this.taskCounter.sum();
    }

    @Override
    public void shutdown() {
        try {
            this.taskExecutor.shutdown();
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.taskExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(timerTaskEntry.getTimerTask());
        }
    }

    @Override
    public void accept(TimerTaskEntry timerTaskEntry) {
        this.addTimerTaskEntry(timerTaskEntry);
    }
}

