/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.thread.pool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.tio.utils.thread.pool.AbstractSynRunnable;

public class SynThreadPoolExecutor
extends ThreadPoolExecutor {
    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, runnableQueue, threadFactory);
    }

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, runnableQueue, threadFactory, rejectedExecutionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBeforeExecute(Runnable runnable) {
        if (runnable instanceof AbstractSynRunnable) {
            AbstractSynRunnable synRunnable = (AbstractSynRunnable)runnable;
            if (synRunnable.executed) {
                return false;
            }
            boolean tryLock = synRunnable.runningLock.tryLock();
            if (tryLock) {
                try {
                    if (synRunnable.executed) {
                        boolean bl = false;
                        return bl;
                    }
                    synRunnable.executed = true;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    synRunnable.runningLock.unlock();
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        if (runnable instanceof AbstractSynRunnable) {
            AbstractSynRunnable synRunnable = (AbstractSynRunnable)runnable;
            if (synRunnable.executed) {
                return;
            }
            boolean tryLock = synRunnable.runningLock.tryLock();
            if (tryLock) {
                try {
                    if (synRunnable.executed) {
                        return;
                    }
                    synRunnable.executed = true;
                    super.execute(runnable);
                }
                finally {
                    synRunnable.runningLock.unlock();
                }
            }
        } else {
            super.execute(runnable);
        }
    }

    public <R> Future<R> submit(Runnable runnable, R result) {
        if (this.checkBeforeExecute(runnable)) {
            return super.submit(runnable, result);
        }
        return null;
    }
}

