/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.queue;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.queue.DataFile;
import org.tio.utils.queue.Mapped;
import org.tio.utils.queue.OffsetFile;

final class Writer<E>
extends Mapped {
    private static final Logger log = LoggerFactory.getLogger(Writer.class);
    static final String NAME = "data.write";
    private final Path path;
    private final long mfs;
    private final long mds;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition;
    private OffsetFile offset;
    private DataFile data;
    long dataIdx;
    long offsetIdx;
    private long maxDataIdx;
    private long maxOffsetIdx;

    Writer(Path path, long mfs, long mds) throws IOException {
        super(path.resolve(NAME), 0L, 8L);
        this.path = path;
        this.mfs = mfs;
        this.mds = mds;
        this.condition = this.lock.newCondition();
        this.dataIdx = this.readCurrentDataIndex();
        this.offset = this.initOffsetMapped();
        this.offsetIdx = this.readCurrentOffsetIndex();
        this.data = this.initDataMapped();
        this.maxDataIdx = this.readMaxDataIndex();
    }

    void write(E element, Function<E, byte[]> mapper) {
        if (element == null) {
            throw new NullPointerException("\u6587\u4ef6\u961f\u5217\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        byte[] bytes = mapper.apply(element);
        if ((long)bytes.length > this.mds) {
            throw new IllegalArgumentException("\u6570\u636e\u8d85\u957f, max: " + this.mds + ", cur: " + bytes.length);
        }
        this.write(bytes);
    }

    void write(byte[] bytes) {
        this.lock.lock();
        try {
            this.writeData(bytes);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeData(byte[] bytes) {
        if (this.data == null) {
            return;
        }
        long inc = this.offsetIdx + (long)bytes.length;
        if (inc > this.maxOffsetIdx) {
            this.dataGrow();
        }
        this.data.write(bytes);
        if (++this.dataIdx > this.maxDataIdx) {
            this.offsetGrow();
        }
        this.offset.write(inc);
        this.buffer.putLong(this.dataIdx);
        this.buffer.flip();
        this.offsetIdx = inc;
    }

    private void offsetGrow() {
        try {
            Path newFile = Writer.pathname(this.path, this.dataIdx - 1L, ".offset");
            this.offset.close();
            this.data.force();
            this.force();
            this.maxDataIdx += this.mfs / 8L;
            this.offset = new OffsetFile(newFile, 0L, this.mfs);
            log.debug("\u504f\u79fb\u91cf\u6587\u4ef6\u6269\u5bb9:{}", (Object)newFile);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u521b\u5efa\u6570\u636e\u504f\u79fb\u91cf\u6587\u4ef6\u6620\u5c04\u5730\u5740\u5f02\u5e38", e);
        }
    }

    private void dataGrow() {
        try {
            Path newFile = Writer.pathname(this.path, this.offsetIdx, ".data");
            this.data.close();
            this.offset.force();
            this.force();
            this.maxOffsetIdx = this.offsetIdx + this.mfs;
            this.data = new DataFile(newFile, 0L, this.mfs);
            log.debug("\u6570\u636e\u6587\u4ef6\u6269\u5bb9:{}", (Object)newFile);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u521b\u5efa\u6570\u636e\u6587\u4ef6\u6620\u5c04\u5730\u5740\u5f02\u5e38", e);
        }
    }

    private long readCurrentDataIndex() {
        long idx = this.buffer.getLong();
        this.buffer.flip();
        return idx;
    }

    private OffsetFile initOffsetMapped() throws IOException {
        long name = 0L;
        if (this.dataIdx != 0L && this.dataIdx % (this.mfs / 8L) == 0L) {
            name = this.dataIdx - this.mfs / 8L;
        } else if (this.dataIdx % (this.mfs / 8L) != 0L) {
            name = this.dataIdx - this.dataIdx % (this.mfs / 8L);
        }
        Path pathname = Writer.pathname(this.path, name, ".offset");
        if (this.dataIdx != 0L && Files.notExists(pathname, new LinkOption[0])) {
            throw new FileNotFoundException("\u7a0b\u5e8f\u6709\u8bef,\u9700\u8981\u8bfb\u7684\u6587\u4ef6\u627e\u4e0d\u5230,\u6587\u4ef6\u540d:" + pathname);
        }
        if (this.dataIdx != 0L && this.dataIdx * 8L % this.mfs == 0L) {
            return new OffsetFile(pathname, this.mfs, 0L);
        }
        return new OffsetFile(pathname, this.dataIdx * 8L % this.mfs, this.mfs - this.dataIdx * 8L % this.mfs);
    }

    private long readCurrentOffsetIndex() throws IOException {
        if (this.dataIdx == 0L) {
            return 0L;
        }
        long pos = this.dataIdx * 8L % this.mfs - 8L;
        if (this.dataIdx * 8L % this.mfs == 0L) {
            pos = this.mfs - 8L;
        }
        return this.offset.get(pos, 8);
    }

    private DataFile initDataMapped() throws IOException {
        long name = DataFile.name(this.path, this.offsetIdx, this.mfs);
        if (name < 0L || this.offsetIdx - name > this.mfs || this.offsetIdx < name) {
            throw new IOException("\u6587\u4ef6\u504f\u79fb\u91cf\u5f02\u5e38, \u83b7\u53d6\u7684\u6570\u636e\u6587\u4ef6: " + name + ", \u5f53\u524d\u9700\u8981\u5199\u5165\u7684\u504f\u79fb\u91cf: " + this.offsetIdx);
        }
        Path pathname = Writer.pathname(this.path, name, ".data");
        if (this.dataIdx != 0L && Files.notExists(pathname, new LinkOption[0])) {
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01" + pathname);
        }
        this.maxOffsetIdx = name + this.mfs;
        return new DataFile(pathname, this.offsetIdx - name, name + this.mfs - this.offsetIdx);
    }

    private long readMaxDataIndex() {
        return (this.dataIdx == 0L || this.dataIdx % (this.mfs / 8L) != 0L ? this.dataIdx / (this.mfs / 8L) + 1L : this.dataIdx / (this.mfs / 8L)) * (this.mfs / 8L);
    }

    void waiting() throws InterruptedException {
        this.lock.lock();
        try {
            this.condition.await();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            super.close();
            this.data.close();
            this.data = null;
            this.offset.close();
            this.offset = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

