/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.tio.utils.json.JsonAdapter;
import org.tio.utils.mica.ExceptionUtils;

public class Jackson2JsonAdapter
implements JsonAdapter {
    public static final String CLAZZ_NAME = "com.fasterxml.jackson.databind.ObjectMapper";
    private final ObjectMapper objectMapper;

    public Jackson2JsonAdapter() {
        this(new ObjectMapper());
    }

    public Jackson2JsonAdapter(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null.").copy();
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_ABSENT);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public String toJsonString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public byte[] toJsonBytes(Object object) {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> T readValue(String json, Type type) {
        try {
            return (T)this.objectMapper.readValue(json, this.getJavaType(type));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> T readValue(byte[] json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> T readValue(byte[] json, Type type) {
        try {
            return (T)this.objectMapper.readValue(json, this.getJavaType(type));
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> List<T> readList(String json, Class<T> clazz) {
        CollectionType javaType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)this.objectMapper.readValue(json, (JavaType)javaType);
        }
        catch (JsonProcessingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> List<T> readList(byte[] json, Class<T> clazz) {
        CollectionType javaType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)this.objectMapper.readValue(json, (JavaType)javaType);
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    @Override
    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.objectMapper.convertValue(fromValue, toValueType);
    }

    @Override
    public <T> T convertValue(Object fromValue, Type toValueType) {
        return (T)this.objectMapper.convertValue(fromValue, this.getJavaType(toValueType));
    }

    private JavaType getJavaType(Type type) {
        return this.objectMapper.getTypeFactory().constructType(type);
    }
}

