/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.tio.utils.json.JsonAdapter;

public class GsonJsonAdapter
implements JsonAdapter {
    public static final String CLAZZ_NAME = "com.google.gson.Gson";
    private final Gson gson;

    public GsonJsonAdapter() {
        this(new Gson());
    }

    public GsonJsonAdapter(Gson gson) {
        this.gson = Objects.requireNonNull(gson, "gson is null.");
    }

    public GsonJsonAdapter(GsonBuilder gsonBuilder) {
        this(Objects.requireNonNull(gsonBuilder, "gsonBuilder is null.").create());
    }

    @Override
    public String toJsonString(Object object) {
        return this.gson.toJson(object);
    }

    @Override
    public <T> T readValue(String json, Class<T> clazz) {
        return (T)this.gson.fromJson(json, clazz);
    }

    @Override
    public <T> T readValue(String json, Type type) {
        return (T)this.gson.fromJson(json, type);
    }

    @Override
    public <T> List<T> readList(String json, Class<T> clazz) {
        return (List)this.gson.fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
    }
}

