/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tio.utils.cache.AbstractCache;
import org.tio.utils.cache.CacheListener;
import org.tio.utils.cache.CacheObj;
import org.tio.utils.cache.ReentrantCache;

public class LRUCache<K extends Serializable, V extends Serializable>
extends ReentrantCache<K, V> {
    private static final long serialVersionUID = 1L;

    public LRUCache(int capacity) {
        this(capacity, 0L);
    }

    public LRUCache(int capacity, CacheListener<K, V> listener) {
        this(capacity, 0L, listener);
    }

    public LRUCache(int capacity, long timeout) {
        this(capacity, timeout, null);
    }

    public LRUCache(int capacity, long timeout, CacheListener<K, V> listener) {
        super(LRUCache.getCacheMap(capacity, listener), capacity, timeout);
        super.setListener((CacheListener)listener);
    }

    private static <K extends Serializable, V extends Serializable> Map<K, CacheObj<K, V>> getCacheMap(final int capacity, final CacheListener<K, V> listener) {
        return new LinkedHashMap<K, CacheObj<K, V>>(capacity + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CacheObj<K, V>> eldest) {
                if (this.size() > capacity) {
                    if (null != listener) {
                        CacheObj entry = eldest.getValue();
                        listener.onRemove(entry.key, entry.obj);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        throw new IllegalArgumentException("\u8bf7\u4f7f\u7528\u6784\u9020\u65b9\u6cd5\u6dfb\u52a0 CacheListener \u53c2\u6570");
    }

    @Override
    protected int pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObj co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }
}

