/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.tio.utils.hutool.CollUtil;

public class HeaderName {
    private static final ConcurrentMap<String, HeaderName> map = new ConcurrentHashMap<String, HeaderName>();
    public static final HeaderName SET_COOKIE = HeaderName.from("Set-Cookie");
    public static final HeaderName Content_Type = HeaderName.from("Content-Type");
    public static final HeaderName Cache_Control = HeaderName.from("Cache-Control");
    public static final HeaderName Location = HeaderName.from("Location");
    public static final HeaderName Connection = HeaderName.from("Connection");
    public static final HeaderName Keep_Alive = HeaderName.from("Keep-Alive");
    public static final HeaderName Content_Length = HeaderName.from("Content-Length");
    public static final HeaderName Access_Control_Allow_Origin = HeaderName.from("Access-Control-Allow-Origin");
    public static final HeaderName Access_Control_Allow_Headers = HeaderName.from("Access-Control-Allow-Headers");
    public static final HeaderName Access_Control_Allow_Methods = HeaderName.from("Access-Control-Allow-Methods");
    public static final HeaderName Access_Control_Max_Age = HeaderName.from("Access-Control-Max-Age");
    public static final HeaderName Access_Control_Allow_Credentials = HeaderName.from("Access-Control-Allow-Credentials");
    public static final HeaderName Content_Disposition = HeaderName.from("Content-Disposition");
    public static final HeaderName Content_Encoding = HeaderName.from("Content-Encoding");
    public static final HeaderName Transfer_Encoding = new HeaderName("Transfer-Encoding");
    public static final HeaderName Date = HeaderName.from("Date");
    public static final HeaderName Expires = HeaderName.from("Expires");
    public static final HeaderName Last_Modified = HeaderName.from("Last-Modified");
    public static final HeaderName Refresh = HeaderName.from("Refresh");
    public static final HeaderName Sec_WebSocket_Accept = HeaderName.from("Sec-WebSocket-Accept");
    public static final HeaderName Sec_Websocket_Protocol = HeaderName.from("sec-websocket-protocol");
    public static final HeaderName Server = HeaderName.from("Server");
    public static final HeaderName Upgrade = HeaderName.from("Upgrade");
    public final String name;
    public final byte[] bytes;

    private HeaderName(String name) {
        this.name = name;
        this.bytes = name.getBytes();
    }

    public static HeaderName from(String name) {
        return (HeaderName)CollUtil.computeIfAbsent(map, (Object)name, HeaderName::new);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderName other = (HeaderName)obj;
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }
}

