/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.task;

import java.time.LocalDateTime;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.stat.GroupStat;
import org.tio.core.task.HeartbeatMode;
import org.tio.server.ServerGroupStat;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;

public class ServerHeartbeatTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(ServerHeartbeatTask.class);
    private final Timer timer;
    private final TioServerConfig serverConfig;
    private final HeartbeatMode heartbeatMode;
    private final GroupStat groupStat;
    private final TioServerListener serverListener;

    public ServerHeartbeatTask(Timer timer, TioServerConfig serverConfig) {
        super(serverConfig.heartbeatTimeout);
        this.timer = timer;
        this.serverConfig = serverConfig;
        this.heartbeatMode = serverConfig.getHeartbeatMode();
        this.groupStat = serverConfig.getGroupStat();
        this.serverListener = serverConfig.getTioServerListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block21: {
            if (this.serverConfig.isStopped()) {
                return;
            }
            if (!this.serverConfig.isNeedCheckHeartbeat()) {
                return;
            }
            this.timer.add((TimerTask)this);
            long start = System.currentTimeMillis();
            Set contextSet = this.serverConfig.connections;
            long heartbeatPeriod = this.serverConfig.heartbeatTimeout;
            float heartbeatBackoff = this.serverConfig.getHeartbeatBackoff();
            long heartbeatTimeout = (long)((float)heartbeatPeriod * heartbeatBackoff);
            long start1 = 0L;
            int count = 0;
            long decodeQueueSizeAll = 0L;
            long handlerQueueSizeAll = 0L;
            long sendQueueSizeAll = 0L;
            start1 = System.currentTimeMillis();
            for (ChannelContext channelContext : contextSet) {
                int sendQueueSize;
                int handlerQueueSize;
                boolean needRemove;
                ++count;
                long compareTime = this.heartbeatMode.getLastTime(channelContext.stat);
                long currTime = System.currentTimeMillis();
                long interval = currTime - compareTime;
                if (channelContext.heartbeatTimeout != null && channelContext.heartbeatTimeout > 0L) {
                    needRemove = (float)interval > (float)channelContext.heartbeatTimeout.longValue() * heartbeatBackoff;
                } else {
                    boolean bl = needRemove = interval > heartbeatTimeout;
                }
                if (needRemove && !this.serverListener.onHeartbeatTimeout(channelContext, interval, channelContext.stat.heartbeatTimeoutCount.incrementAndGet())) {
                    log.info("{}, {} ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f", (Object)channelContext, (Object)interval);
                    channelContext.setCloseCode(ChannelContext.CloseCode.HEARTBEAT_TIMEOUT);
                    Tio.remove(channelContext, interval + " ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f");
                    continue;
                }
                int decodeQueueSize = channelContext.getDecodeQueueSize();
                if (decodeQueueSize > 0) {
                    decodeQueueSizeAll += (long)decodeQueueSize;
                }
                if ((handlerQueueSize = channelContext.getHandlerQueueSize()) > 0) {
                    handlerQueueSizeAll += (long)handlerQueueSize;
                }
                if ((sendQueueSize = channelContext.getSendQueueSize()) <= 0) continue;
                sendQueueSizeAll += (long)sendQueueSize;
            }
            try {
                if (this.serverConfig.debug && log.isWarnEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\r\n").append(this.serverConfig.getName());
                    builder.append("\r\n \u251c \u5f53\u524d\u65f6\u95f4 :").append(LocalDateTime.now());
                    builder.append("\r\n \u251c \u8fde\u63a5\u7edf\u8ba1");
                    builder.append("\r\n \u2502 \t \u251c \u5171\u63a5\u53d7\u8fc7\u8fde\u63a5\u6570 :").append(((ServerGroupStat)this.groupStat).accepted.sum());
                    builder.append("\r\n \u2502 \t \u251c \u5f53\u524d\u8fde\u63a5\u6570 :").append(contextSet.size());
                    builder.append("\r\n \u2502 \t \u2514 \u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570 :").append(this.groupStat.closed.sum());
                    builder.append("\r\n \u251c \u6d88\u606f\u7edf\u8ba1");
                    builder.append("\r\n \u2502 \t \u251c \u5df2\u5904\u7406\u6d88\u606f :").append(this.groupStat.handledPackets.sum());
                    builder.append("\r\n \u2502 \t \u251c \u5df2\u63a5\u6536\u6d88\u606f(packet/byte) :").append(this.groupStat.receivedPackets.sum()).append('/').append(this.groupStat.receivedBytes.sum());
                    builder.append("\r\n \u2502 \t \u251c \u5df2\u53d1\u9001\u6d88\u606f(packet/byte) :").append(this.groupStat.sentPackets.sum()).append('/').append(this.groupStat.sentBytes.sum()).append('b');
                    builder.append("\r\n \u2502 \t \u251c \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570 :").append(this.groupStat.getBytesPerTcpReceive());
                    builder.append("\r\n \u2502 \t \u2514 \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305 :").append(this.groupStat.getPacketsPerTcpReceive());
                    builder.append("\r\n \u251c \u8282\u70b9\u7edf\u8ba1");
                    builder.append("\r\n \u2502 \t \u251c clientNodes :").append(this.serverConfig.clientNodes.size());
                    builder.append("\r\n \u2502 \t \u251c \u6240\u6709\u8fde\u63a5 :").append(this.serverConfig.connections.size());
                    builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9auser\u6570 :").append(this.serverConfig.users.size());
                    builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9atoken\u6570 :").append(this.serverConfig.tokens.size());
                    builder.append("\r\n \u2502 \t \u2514 \u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94 :").append(this.serverConfig.waitingResps.size());
                    builder.append("\r\n \u251c \u961f\u5217\u7edf\u8ba1");
                    builder.append("\r\n \u2502 \t \u251c \u89e3\u7801\u961f\u5217\u603b\u6570 :").append(decodeQueueSizeAll);
                    builder.append("\r\n \u2502 \t \u251c \u5904\u7406\u961f\u5217\u603b\u6570 :").append(handlerQueueSizeAll);
                    builder.append("\r\n \u2502 \t \u2514 \u53d1\u9001\u961f\u5217\u603b\u6570 :").append(sendQueueSizeAll);
                    builder.append("\r\n \u2514 \u7fa4\u7ec4");
                    builder.append("\r\n   \t \u2514 groupmap: ").append(this.serverConfig.groups.size());
                    log.warn(builder.toString());
                    long end = System.currentTimeMillis();
                    long iv1 = start1 - start;
                    long iv = end - start1;
                    log.warn("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u68c0\u6d4b\u5468\u671f:{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{this.serverConfig.getName(), count, iv1, iv, heartbeatPeriod, heartbeatTimeout});
                }
                break block21;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            break block21;
            catch (Throwable e) {
                try {
                    log.error(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.serverConfig.debug && log.isWarnEnabled()) {
                            StringBuilder builder = new StringBuilder();
                            builder.append("\r\n").append(this.serverConfig.getName());
                            builder.append("\r\n \u251c \u5f53\u524d\u65f6\u95f4 :").append(LocalDateTime.now());
                            builder.append("\r\n \u251c \u8fde\u63a5\u7edf\u8ba1");
                            builder.append("\r\n \u2502 \t \u251c \u5171\u63a5\u53d7\u8fc7\u8fde\u63a5\u6570 :").append(((ServerGroupStat)this.groupStat).accepted.sum());
                            builder.append("\r\n \u2502 \t \u251c \u5f53\u524d\u8fde\u63a5\u6570 :").append(contextSet.size());
                            builder.append("\r\n \u2502 \t \u2514 \u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570 :").append(this.groupStat.closed.sum());
                            builder.append("\r\n \u251c \u6d88\u606f\u7edf\u8ba1");
                            builder.append("\r\n \u2502 \t \u251c \u5df2\u5904\u7406\u6d88\u606f :").append(this.groupStat.handledPackets.sum());
                            builder.append("\r\n \u2502 \t \u251c \u5df2\u63a5\u6536\u6d88\u606f(packet/byte) :").append(this.groupStat.receivedPackets.sum()).append('/').append(this.groupStat.receivedBytes.sum());
                            builder.append("\r\n \u2502 \t \u251c \u5df2\u53d1\u9001\u6d88\u606f(packet/byte) :").append(this.groupStat.sentPackets.sum()).append('/').append(this.groupStat.sentBytes.sum()).append('b');
                            builder.append("\r\n \u2502 \t \u251c \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570 :").append(this.groupStat.getBytesPerTcpReceive());
                            builder.append("\r\n \u2502 \t \u2514 \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305 :").append(this.groupStat.getPacketsPerTcpReceive());
                            builder.append("\r\n \u251c \u8282\u70b9\u7edf\u8ba1");
                            builder.append("\r\n \u2502 \t \u251c clientNodes :").append(this.serverConfig.clientNodes.size());
                            builder.append("\r\n \u2502 \t \u251c \u6240\u6709\u8fde\u63a5 :").append(this.serverConfig.connections.size());
                            builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9auser\u6570 :").append(this.serverConfig.users.size());
                            builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9atoken\u6570 :").append(this.serverConfig.tokens.size());
                            builder.append("\r\n \u2502 \t \u2514 \u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94 :").append(this.serverConfig.waitingResps.size());
                            builder.append("\r\n \u251c \u961f\u5217\u7edf\u8ba1");
                            builder.append("\r\n \u2502 \t \u251c \u89e3\u7801\u961f\u5217\u603b\u6570 :").append(decodeQueueSizeAll);
                            builder.append("\r\n \u2502 \t \u251c \u5904\u7406\u961f\u5217\u603b\u6570 :").append(handlerQueueSizeAll);
                            builder.append("\r\n \u2502 \t \u2514 \u53d1\u9001\u961f\u5217\u603b\u6570 :").append(sendQueueSizeAll);
                            builder.append("\r\n \u2514 \u7fa4\u7ec4");
                            builder.append("\r\n   \t \u2514 groupmap: ").append(this.serverConfig.groups.size());
                            log.warn(builder.toString());
                            long end = System.currentTimeMillis();
                            long iv1 = start1 - start;
                            long iv = end - start1;
                            log.warn("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u68c0\u6d4b\u5468\u671f:{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{this.serverConfig.getName(), count, iv1, iv, heartbeatPeriod, heartbeatTimeout});
                        }
                    }
                    catch (Throwable e2) {
                        log.error(e2.getMessage(), e2);
                    }
                    throw throwable;
                }
                try {
                    if (this.serverConfig.debug && log.isWarnEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("\r\n").append(this.serverConfig.getName());
                        builder.append("\r\n \u251c \u5f53\u524d\u65f6\u95f4 :").append(LocalDateTime.now());
                        builder.append("\r\n \u251c \u8fde\u63a5\u7edf\u8ba1");
                        builder.append("\r\n \u2502 \t \u251c \u5171\u63a5\u53d7\u8fc7\u8fde\u63a5\u6570 :").append(((ServerGroupStat)this.groupStat).accepted.sum());
                        builder.append("\r\n \u2502 \t \u251c \u5f53\u524d\u8fde\u63a5\u6570 :").append(contextSet.size());
                        builder.append("\r\n \u2502 \t \u2514 \u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570 :").append(this.groupStat.closed.sum());
                        builder.append("\r\n \u251c \u6d88\u606f\u7edf\u8ba1");
                        builder.append("\r\n \u2502 \t \u251c \u5df2\u5904\u7406\u6d88\u606f :").append(this.groupStat.handledPackets.sum());
                        builder.append("\r\n \u2502 \t \u251c \u5df2\u63a5\u6536\u6d88\u606f(packet/byte) :").append(this.groupStat.receivedPackets.sum()).append('/').append(this.groupStat.receivedBytes.sum());
                        builder.append("\r\n \u2502 \t \u251c \u5df2\u53d1\u9001\u6d88\u606f(packet/byte) :").append(this.groupStat.sentPackets.sum()).append('/').append(this.groupStat.sentBytes.sum()).append('b');
                        builder.append("\r\n \u2502 \t \u251c \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570 :").append(this.groupStat.getBytesPerTcpReceive());
                        builder.append("\r\n \u2502 \t \u2514 \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305 :").append(this.groupStat.getPacketsPerTcpReceive());
                        builder.append("\r\n \u251c \u8282\u70b9\u7edf\u8ba1");
                        builder.append("\r\n \u2502 \t \u251c clientNodes :").append(this.serverConfig.clientNodes.size());
                        builder.append("\r\n \u2502 \t \u251c \u6240\u6709\u8fde\u63a5 :").append(this.serverConfig.connections.size());
                        builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9auser\u6570 :").append(this.serverConfig.users.size());
                        builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9atoken\u6570 :").append(this.serverConfig.tokens.size());
                        builder.append("\r\n \u2502 \t \u2514 \u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94 :").append(this.serverConfig.waitingResps.size());
                        builder.append("\r\n \u251c \u961f\u5217\u7edf\u8ba1");
                        builder.append("\r\n \u2502 \t \u251c \u89e3\u7801\u961f\u5217\u603b\u6570 :").append(decodeQueueSizeAll);
                        builder.append("\r\n \u2502 \t \u251c \u5904\u7406\u961f\u5217\u603b\u6570 :").append(handlerQueueSizeAll);
                        builder.append("\r\n \u2502 \t \u2514 \u53d1\u9001\u961f\u5217\u603b\u6570 :").append(sendQueueSizeAll);
                        builder.append("\r\n \u2514 \u7fa4\u7ec4");
                        builder.append("\r\n   \t \u2514 groupmap: ").append(this.serverConfig.groups.size());
                        log.warn(builder.toString());
                        long end = System.currentTimeMillis();
                        long iv1 = start1 - start;
                        long iv = end - start1;
                        log.warn("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u68c0\u6d4b\u5468\u671f:{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{this.serverConfig.getName(), count, iv1, iv, heartbeatPeriod, heartbeatTimeout});
                    }
                }
                catch (Throwable e3) {
                    log.error(e3.getMessage(), e3);
                }
            }
        }
    }
}

