/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.proxy;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.IgnorePacket;
import org.tio.core.intf.Packet;
import org.tio.server.intf.DecoderFunction;
import org.tio.server.proxy.ProxyProtocolMessage;
import org.tio.utils.buffer.ByteBufferUtil;

public final class ProxyProtocolDecoder {
    private static final int V1_MIN_HEAD_LENGTH = 6;
    private static final int V1_MAX_LENGTH = 108;
    private static final String PROXY_PROTOCOL_KEY = "proxy_protocol_key";
    private static final String UNKNOWN = "UNKNOWN";

    private ProxyProtocolDecoder() {
    }

    public static void enableProxyProtocol(ChannelContext context) {
        context.set(PROXY_PROTOCOL_KEY, (byte)1);
    }

    public static void removeProxyProtocol(ChannelContext context) {
        context.remove(PROXY_PROTOCOL_KEY);
    }

    public static boolean isProxyProtocolEnabled(ChannelContext context) {
        return context.containsKey(PROXY_PROTOCOL_KEY);
    }

    public static Packet decodeIfEnable(ChannelContext context, ByteBuffer buffer, int readableLength, DecoderFunction next) throws TioDecodeException {
        if (ProxyProtocolDecoder.isProxyProtocolEnabled(context)) {
            return ProxyProtocolDecoder.decode(context, buffer, readableLength, next);
        }
        return next.apply(context, buffer, readableLength);
    }

    public static Packet decode(ChannelContext context, ByteBuffer buffer, int readableLength, DecoderFunction next) throws TioDecodeException {
        if (readableLength < 6) {
            return next.apply(context, buffer, readableLength);
        }
        buffer.mark();
        String proxyPrefix = ByteBufferUtil.readString((ByteBuffer)buffer, (int)6, (Charset)StandardCharsets.US_ASCII);
        if (!"PROXY ".equals(proxyPrefix)) {
            context.remove(PROXY_PROTOCOL_KEY);
            buffer.reset();
            return next.apply(context, buffer, readableLength);
        }
        ProxyProtocolMessage message = ProxyProtocolDecoder.decodeMessage(buffer, readableLength);
        if (message == null) {
            return null;
        }
        context.remove(PROXY_PROTOCOL_KEY);
        String protocol = message.getProtocol();
        if (UNKNOWN.equals(protocol)) {
            context.setProxyClientNode(new Node(UNKNOWN, message.getDestinationPort()));
        } else {
            context.setClientNode(new Node(message.getSourceAddress(), message.getSourcePort()));
            context.setProxyClientNode(new Node(message.getDestinationAddress(), message.getDestinationPort()));
        }
        if (buffer.hasRemaining()) {
            return next.apply(context, buffer, readableLength);
        }
        return IgnorePacket.INSTANCE;
    }

    public static ProxyProtocolMessage decodeForTest(ByteBuffer buffer, int readableLength) throws TioDecodeException {
        String proxyPrefix = ByteBufferUtil.readString((ByteBuffer)buffer, (int)6, (Charset)StandardCharsets.US_ASCII);
        if (!"PROXY ".equals(proxyPrefix)) {
            throw new TioDecodeException("unknown identifier: " + proxyPrefix);
        }
        return ProxyProtocolDecoder.decodeMessage(buffer, readableLength);
    }

    public static ProxyProtocolMessage decodeMessage(ByteBuffer buffer, int readableLength) throws TioDecodeException {
        int endOfLine = ProxyProtocolDecoder.findEndOfLine(buffer);
        if (endOfLine > 108 || readableLength > 108 && endOfLine == -1) {
            throw new TioDecodeException("Error v1 proxy protocol, readableLength: " + readableLength);
        }
        if (endOfLine == -1) {
            return null;
        }
        String header = ByteBufferUtil.readString((ByteBuffer)buffer, (int)(endOfLine - 6), (Charset)StandardCharsets.US_ASCII);
        ByteBufferUtil.skipBytes((ByteBuffer)buffer, (int)2);
        String[] parts = header.split(" ");
        int numParts = parts.length;
        if (numParts < 1) {
            throw new TioDecodeException("invalid header: PROXY " + header + " (expected: 'PROXY' and proxied protocol values)");
        }
        String proxyProtocol = parts[0];
        if (!("TCP4".equals(proxyProtocol) || "TCP6".equals(proxyProtocol) || UNKNOWN.equals(proxyProtocol))) {
            throw new TioDecodeException("unsupported v1 proxy protocol: " + proxyProtocol);
        }
        if (UNKNOWN.equals(proxyProtocol)) {
            return ProxyProtocolDecoder.unknownMsg();
        }
        if (numParts != 5) {
            throw new TioDecodeException("invalid TCP4/6 header: PROXY " + header + " (expected: 6 parts)");
        }
        return new ProxyProtocolMessage(proxyProtocol, parts[1], parts[2], parts[3], parts[4]);
    }

    private static ProxyProtocolMessage unknownMsg() {
        return new ProxyProtocolMessage(UNKNOWN, null, null, 0, 0);
    }

    private static int findEndOfLine(ByteBuffer buffer) {
        int n = buffer.limit();
        for (int i = buffer.position(); i < n; ++i) {
            byte b = buffer.get(i);
            if (b != 13 || i >= n - 1 || buffer.get(i + 1) != 10) continue;
            return i;
        }
        return -1;
    }
}

