/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.cluster.codec;

import java.nio.ByteBuffer;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.server.cluster.message.ClusterDataMessage;
import org.tio.server.cluster.message.ClusterJoinMessage;
import org.tio.server.cluster.message.ClusterMessageType;
import org.tio.server.cluster.message.ClusterPingMessage;
import org.tio.server.cluster.message.ClusterPongMessage;
import org.tio.server.cluster.message.ClusterSyncAckMessage;
import org.tio.server.cluster.message.ClusterSyncMessage;
import org.tio.utils.buffer.ByteBufferUtil;
import org.tio.utils.mica.Pair;

public class ClusterMessageDecoder {
    public Packet decode(ChannelContext ctx, ByteBuffer buffer, int readableLength) throws TioDecodeException {
        if (readableLength < 1) {
            return null;
        }
        ClusterMessageType messageType = ClusterMessageType.from(buffer.get());
        switch (messageType) {
            case PING: {
                return ClusterPingMessage.INSTANCE;
            }
            case PONG: {
                return ClusterPongMessage.INSTANCE;
            }
            case DATA: {
                return ClusterMessageDecoder.decodeDataMessage(ctx, buffer, readableLength);
            }
            case SYNC: {
                return ClusterMessageDecoder.decodeSyncMessage(ctx, buffer, readableLength);
            }
            case SYNC_ACK: {
                return ClusterMessageDecoder.decodeSyncAckMessage(ctx, buffer, readableLength);
            }
            case JOIN: {
                return ClusterMessageDecoder.decodeJoinMessage(ctx, buffer, readableLength);
            }
        }
        throw new TioDecodeException("\u6682\u4e0d\u652f\u6301\u7684\u96c6\u7fa4\u6d88\u606f\u7c7b\u578b");
    }

    private static ClusterDataMessage decodeDataMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        Pair<Integer, Integer> dataLengthPair = ClusterMessageDecoder.readDataPacketLength(buffer);
        if (dataLengthPair == null) {
            return null;
        }
        int dataLength = (Integer)dataLengthPair.getLeft();
        int dataLengthLength = (Integer)dataLengthPair.getRight();
        int messageLength = 1 + dataLengthLength + dataLength;
        if (readableLength < messageLength) {
            ctx.setPacketNeededLength(messageLength);
            return null;
        }
        byte[] payload = ByteBufferUtil.readBytes((ByteBuffer)buffer, (int)dataLength);
        return new ClusterDataMessage(payload);
    }

    private static ClusterSyncMessage decodeSyncMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        if (readableLength < 9) {
            return null;
        }
        long messageId = buffer.getLong();
        Pair<Integer, Integer> dataLengthPair = ClusterMessageDecoder.readDataPacketLength(buffer);
        if (dataLengthPair == null) {
            return null;
        }
        int dataLength = (Integer)dataLengthPair.getLeft();
        int dataLengthLength = (Integer)dataLengthPair.getRight();
        int messageLength = 9 + dataLengthLength + dataLength;
        if (readableLength < messageLength) {
            ctx.setPacketNeededLength(messageLength);
            return null;
        }
        byte[] payload = ByteBufferUtil.readBytes((ByteBuffer)buffer, (int)dataLength);
        return new ClusterSyncMessage(messageId, payload);
    }

    private static ClusterSyncAckMessage decodeSyncAckMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        int packetLength = 9;
        if (readableLength < packetLength) {
            ctx.setPacketNeededLength(packetLength);
            return null;
        }
        long messageId = buffer.getLong();
        return new ClusterSyncAckMessage(messageId);
    }

    private static ClusterJoinMessage decodeJoinMessage(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        int messageLength = 35;
        if (readableLength < messageLength) {
            ctx.setPacketNeededLength(messageLength);
            return null;
        }
        int port = ByteBufferUtil.readUnsignedShortLE((ByteBuffer)buffer);
        String ip = ByteBufferUtil.readString((ByteBuffer)buffer, (int)32);
        return new ClusterJoinMessage(new Node(ip.trim(), port));
    }

    private static Pair<Integer, Integer> readDataPacketLength(ByteBuffer buffer) {
        short digit;
        int remainingLength = 0;
        int multiplier = 1;
        int count = 0;
        do {
            if (!buffer.hasRemaining()) {
                return null;
            }
            digit = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
            remainingLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0 && ++count < 4);
        return new Pair((Object)remainingLength, (Object)count);
    }
}

