/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.TioServerConfig;
import org.tio.server.task.ServerHeartbeatTask;
import org.tio.utils.Version;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.hutool.DateUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.timer.DefaultTimerTaskService;
import org.tio.utils.timer.SystemTimer;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskService;

public class TioServer {
    private static final Logger log = LoggerFactory.getLogger(TioServer.class);
    private final Node serverNode;
    private final TioServerConfig serverConfig;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private AsynchronousChannelGroup channelGroup = null;
    private TimerTaskService taskService;
    private boolean isWaitingStop = false;

    public TioServer(int port, TioServerConfig serverConfig) {
        this(null, port, serverConfig);
    }

    public TioServer(String ip, int port, TioServerConfig serverConfig) {
        this(new Node(ip, port), serverConfig);
    }

    public TioServer(Node serverNode, TioServerConfig serverConfig) {
        this.serverNode = Objects.requireNonNull(serverNode, "serverNode \u4e0d\u80fd\u4e3a null");
        this.serverConfig = Objects.requireNonNull(serverConfig, "TioServerConfig \u4e0d\u80fd\u4e3a null");
    }

    public TioServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    private void startHeartbeatTask() {
        if (this.serverConfig.heartbeatTimeout > 0L) {
            this.taskService.addTask(systemTimer -> new ServerHeartbeatTask((Timer)systemTimer, this.serverConfig));
        } else if (this.serverConfig.isNeedCheckHeartbeat()) {
            log.warn("\u7528\u6237\u53d6\u6d88\u4e86 mica-net \u7684\u5fc3\u8df3\u5b9a\u65f6\u53d1\u9001\u529f\u80fd\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u81ea\u5b9a\u4e49\u5fc3\u8df3\u673a\u5236");
        }
    }

    public TimerTask schedule(Runnable command, long delay) {
        return this.schedule(command, delay, null);
    }

    public TimerTask schedule(Runnable command, long delay, Executor executor) {
        return this.taskService.addTask(systemTimer -> new TimerTask(delay, (SystemTimer)systemTimer, executor, command){
            final /* synthetic */ SystemTimer val$systemTimer;
            final /* synthetic */ Executor val$executor;
            final /* synthetic */ Runnable val$command;
            {
                this.val$systemTimer = systemTimer;
                this.val$executor = executor;
                this.val$command = runnable;
                super(x0);
            }

            public void run() {
                try {
                    this.val$systemTimer.add((TimerTask)this);
                    if (this.val$executor == null) {
                        this.val$command.run();
                    } else {
                        this.val$executor.execute(this.val$command);
                    }
                }
                catch (Exception e) {
                    log.error("mica-net server schedule error", (Throwable)e);
                }
            }
        });
    }

    public TimerTask scheduleOnce(Runnable command, long delay) {
        return this.scheduleOnce(command, delay, null);
    }

    public TimerTask scheduleOnce(final Runnable command, long delay, final Executor executor) {
        return this.taskService.addTask(systemTimer -> new TimerTask(delay){

            public void run() {
                try {
                    if (executor == null) {
                        command.run();
                    } else {
                        executor.execute(command);
                    }
                }
                catch (Exception e) {
                    log.error("mica-net server schedule once error", (Throwable)e);
                }
            }
        });
    }

    public void start() throws IOException {
        long start = System.currentTimeMillis();
        this.taskService = TioServer.getTimerTaskService(this.serverConfig);
        this.taskService.start();
        this.startHeartbeatTask();
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(this.serverConfig.groupExecutor);
        this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.channelGroup);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        String serverIp = this.serverNode.getIp();
        InetSocketAddress listenAddress = StrUtil.isBlank((CharSequence)serverIp) ? new InetSocketAddress(this.serverNode.getPort()) : new InetSocketAddress(serverIp, this.serverNode.getPort());
        this.serverSocketChannel.bind(listenAddress, this.serverConfig.getBacklog());
        AcceptCompletionHandler acceptCompletionHandler = this.serverConfig.getAcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        this.serverConfig.startTime = System.currentTimeMillis();
        String baseStr = "|----------------------------------------------------------------------------------------|";
        int baseLen = baseStr.length();
        int xxLen = 18;
        int aaLen = baseLen - 3;
        StackTraceElement[] ses = Thread.currentThread().getStackTrace();
        StackTraceElement se = ses[ses.length - 1];
        ArrayList<String> infoList = new ArrayList<String>();
        String serverConfigName = this.serverConfig.getName();
        if (StrUtil.isNotBlank((CharSequence)serverConfigName)) {
            infoList.add(StrUtil.fillAfter((String)"TioConfig name", (char)' ', (int)xxLen) + "| " + this.serverConfig.getName());
        }
        infoList.add(StrUtil.fillAfter((String)"Mica net version", (char)' ', (int)xxLen) + "| " + Version.getVersion());
        infoList.add(StrUtil.fillAfter((String)"Started at", (char)' ', (int)xxLen) + "| " + DateUtil.formatDateTime((LocalDateTime)LocalDateTime.now()));
        infoList.add(StrUtil.fillAfter((String)"Listen on", (char)' ', (int)xxLen) + "| " + this.serverNode);
        infoList.add(StrUtil.fillAfter((String)"Main Class", (char)' ', (int)xxLen) + "| " + se.getClassName());
        TioServer.startManagementDebugInfo(infoList, xxLen, start);
        StringBuilder printStr = new StringBuilder("\r\n" + baseStr + "\r\n");
        for (String string : infoList) {
            printStr.append("| ").append(StrUtil.fillAfter((String)string, (char)' ', (int)aaLen)).append("|\r\n");
        }
        printStr.append(baseStr).append("\r\n");
        if (log.isInfoEnabled()) {
            log.info(printStr.toString());
        } else {
            System.out.println(printStr);
        }
    }

    private static TimerTaskService getTimerTaskService(TioServerConfig serverConfig) {
        return Optional.ofNullable(serverConfig.getTaskService()).orElseGet(DefaultTimerTaskService::new);
    }

    private static void startManagementDebugInfo(List<String> infoList, int xxLen, long start) {
        boolean hasManagementFactory = ClassUtil.isPresent((String)"java.lang.management.ManagementFactory");
        if (hasManagementFactory) {
            try {
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                long startTime = runtimeMxBean.getStartTime();
                long startCost = System.currentTimeMillis() - startTime;
                String runtimeName = runtimeMxBean.getName();
                String pid = runtimeName.split("@")[0];
                infoList.add(StrUtil.fillAfter((String)"Jvm start time", (char)' ', (int)xxLen) + "| " + startCost + "ms");
                infoList.add(StrUtil.fillAfter((String)"Tio start time", (char)' ', (int)xxLen) + "| " + (System.currentTimeMillis() - start) + "ms");
                infoList.add(StrUtil.fillAfter((String)"Pid", (char)' ', (int)xxLen) + "| " + pid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean stop() {
        boolean ret;
        this.isWaitingStop = true;
        this.serverConfig.remove();
        this.taskService.stop();
        try {
            this.channelGroup.shutdownNow();
        }
        catch (Exception e) {
            log.error("channelGroup.shutdownNow()\u65f6\u62a5\u9519", (Throwable)e);
        }
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception e1) {
            log.error("serverSocketChannel.close()\u65f6\u62a5\u9519", (Throwable)e1);
        }
        this.serverConfig.setStopped(true);
        try {
            this.serverConfig.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.serverConfig.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        try {
            ret = this.serverConfig.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.serverConfig.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ret = false;
            Thread.currentThread().interrupt();
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("{} stopped ret:{}", (Object)this.serverNode, (Object)ret);
        return ret;
    }
}

