/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.udp.task;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.udp.UdpConf;

public class UdpSendRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UdpSendRunnable.class);
    private final LinkedBlockingQueue<DatagramPacket> queue;
    private final UdpConf udpConf;
    private final DatagramSocket datagramSocket;
    private boolean isStopped = false;

    public UdpSendRunnable(LinkedBlockingQueue<DatagramPacket> queue, UdpConf udpConf, DatagramSocket datagramSocket) {
        this.queue = queue;
        this.udpConf = udpConf;
        this.datagramSocket = datagramSocket;
    }

    @Override
    public void run() {
        DatagramSocket datagramSocket = this.datagramSocket;
        while (!this.isStopped) {
            try {
                DatagramPacket datagramPacket = this.queue.take();
                if (datagramSocket == null) {
                    datagramSocket = new DatagramSocket();
                    datagramSocket.setSoTimeout(this.udpConf.getTimeout());
                }
                datagramSocket.send(datagramPacket);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                if (!this.queue.isEmpty() || this.datagramSocket != null || datagramSocket == null) continue;
                datagramSocket.close();
                datagramSocket = null;
            }
        }
    }

    public void stop() {
        this.isStopped = true;
    }
}

