/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import org.tio.core.stat.ChannelStat;

public enum HeartbeatMode {
    LAST_REQ{

        @Override
        public long getLastTime(ChannelStat stat) {
            return stat.latestTimeOfSentPacket;
        }
    }
    ,
    LAST_RESP{

        @Override
        public long getLastTime(ChannelStat stat) {
            return stat.latestTimeOfReceivedByte;
        }
    }
    ,
    ANY{

        @Override
        public long getLastTime(ChannelStat stat) {
            return Math.max(stat.latestTimeOfReceivedByte, stat.latestTimeOfSentPacket);
        }
    }
    ,
    ALL{

        @Override
        public long getLastTime(ChannelStat stat) {
            return Math.min(stat.latestTimeOfReceivedByte, stat.latestTimeOfSentPacket);
        }
    };


    public abstract long getLastTime(ChannelStat var1);
}

