/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.SslConfig;
import org.tio.core.ssl.SslHandshakeCompletedListener;
import org.tio.core.ssl.SslListener;
import org.tio.core.ssl.SslSessionClosedListener;
import org.tio.core.ssl.facade.DefaultTaskHandler;
import org.tio.core.ssl.facade.ISSLFacade;
import org.tio.core.ssl.facade.SSLFacade;

public class SslFacadeContext {
    private static final Logger log = LoggerFactory.getLogger(SslFacadeContext.class);
    private final ChannelContext channelContext;
    private final SSLContext sslContext;
    private final ISSLFacade sslFacade;
    private boolean isHandshakeCompleted;

    public SslFacadeContext(ChannelContext channelContext) {
        this(channelContext, channelContext.tioConfig.sslConfig);
    }

    public SslFacadeContext(ChannelContext channelContext, SslConfig sslConfig) {
        this.channelContext = channelContext;
        this.isHandshakeCompleted = false;
        this.sslContext = sslConfig.getSslContext();
        this.sslFacade = new SSLFacade(this.channelContext, this.sslContext, !this.channelContext.isServer(), sslConfig, new DefaultTaskHandler());
        this.sslFacade.setHandshakeCompletedListener(new SslHandshakeCompletedListener(this.channelContext));
        this.sslFacade.setSSLListener(new SslListener(this.channelContext));
        this.sslFacade.setCloseListener(new SslSessionClosedListener(this.channelContext));
    }

    public void beginHandshake() throws Exception {
        log.info("{} \u5f00\u59cbSSL\u63e1\u624b", (Object)this.channelContext);
        this.sslFacade.beginHandshake();
    }

    public boolean isHandshakeCompleted() {
        return this.isHandshakeCompleted;
    }

    public void setHandshakeCompleted(boolean isHandshakeCompleted) {
        this.isHandshakeCompleted = isHandshakeCompleted;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ISSLFacade getSslFacade() {
        return this.sslFacade;
    }
}

