/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import org.tio.utils.hutool.StrUtil;

public enum SslCertType {
    CRT("CRT", new String[]{".crt"}),
    JKS("JKS", new String[]{".jks", ".keystore"}),
    PKCS12("PKCS12", new String[]{".p12", ".pfx"});

    private final String type;
    private final String[] fileExtensions;

    private SslCertType(String type, String[] fileExtensions) {
        this.type = type;
        this.fileExtensions = fileExtensions;
    }

    public String getType() {
        return this.type;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public static SslCertType from(String fileName) {
        if (StrUtil.isBlank((CharSequence)fileName)) {
            return JKS;
        }
        for (SslCertType certType : SslCertType.values()) {
            String[] fileExtensions;
            for (String fileExtension : fileExtensions = certType.getFileExtensions()) {
                if (!fileName.toLowerCase().endsWith(fileExtension)) continue;
                return certType;
            }
        }
        return JKS;
    }
}

