/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.utils.hutool.StrUtil;

public class BsIds {
    private static final Logger log = LoggerFactory.getLogger(BsIds.class);
    private final ConcurrentMap<String, ChannelContext> map = new ConcurrentHashMap<String, ChannelContext>();

    public void bind(ChannelContext channelContext, String bsId) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            this.unbind(channelContext);
            if (StrUtil.isBlank((CharSequence)bsId)) {
                return;
            }
            channelContext.setBsId(bsId);
            this.map.put(bsId, channelContext);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ChannelContext find(TioConfig tioConfig, String bsId) {
        if (tioConfig.isShortConnection || StrUtil.isBlank((CharSequence)bsId)) {
            return null;
        }
        return (ChannelContext)((Object)this.map.get(bsId));
    }

    public void unbind(ChannelContext channelContext) {
        TioConfig tioConfig = channelContext.tioConfig;
        if (tioConfig.isShortConnection) {
            return;
        }
        String bsId = channelContext.getBsId();
        if (StrUtil.isBlank((CharSequence)bsId)) {
            return;
        }
        this.map.remove(bsId);
        channelContext.setBsId(null);
    }
}

