/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client.task;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.utils.timer.TimerTask;

public class ClientReConnTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ClientReConnTask.class);
    private final TioClient tioClient;
    private final ClientChannelContext channelContext;

    public ClientReConnTask(ClientChannelContext clientChannelContext, ReconnConf reconnConf) {
        super(reconnConf.getInterval());
        this.tioClient = reconnConf.getTioClient();
        this.channelContext = clientChannelContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.channelContext == null) {
            return;
        }
        TioClientConfig tioClientConfig = (TioClientConfig)this.channelContext.getTioConfig();
        if (tioClientConfig.isStopped()) {
            return;
        }
        if (tioClientConfig.debug && logger.isInfoEnabled()) {
            logger.info("connecteds:{}, closeds:{}, connections:{}", new Object[]{tioClientConfig.connecteds.size(), tioClientConfig.closeds.size(), tioClientConfig.connections.size()});
        }
        if (this.channelContext.isRemoved()) {
            return;
        }
        SslFacadeContext sslFacadeContext = this.channelContext.sslFacadeContext;
        if (sslFacadeContext != null) {
            sslFacadeContext.setHandshakeCompleted(false);
        }
        if (this.channelContext.isRemoved() || !this.channelContext.isClosed()) {
            return;
        }
        int reConnCount = this.channelContext.getReconnCount().incrementAndGet();
        ReentrantReadWriteLock closeLock = this.channelContext.closeLock;
        ReentrantReadWriteLock.WriteLock writeLock = closeLock.writeLock();
        writeLock.lock();
        try {
            if (!this.channelContext.isClosed()) {
                return;
            }
            long start = System.currentTimeMillis();
            this.tioClient.reconnect(this.channelContext, 2);
            long end = System.currentTimeMillis();
            long iv = end - start;
            logger.error("{}, \u7b2c{}\u6b21\u91cd\u8fde,\u91cd\u8fde\u8017\u65f6:{} ms", new Object[]{this.channelContext, reConnCount, iv});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            writeLock.unlock();
        }
    }
}

