/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ConnectionCompletionHandler;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.TioClientConfig;
import org.tio.client.task.ClientHeartbeatTask;
import org.tio.core.Node;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.timer.DefaultTimerTaskService;
import org.tio.utils.timer.SystemTimer;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskService;

public class TioClient {
    private static final Logger log = LoggerFactory.getLogger(TioClient.class);
    private final TioClientConfig clientConfig;
    private final TimerTaskService taskService;
    private final AsynchronousChannelGroup channelGroup;

    public TioClient(TioClientConfig tioClientConfig) throws IOException {
        this.clientConfig = tioClientConfig;
        this.taskService = TioClient.getTimerTaskService(tioClientConfig.getTaskService());
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(tioClientConfig.groupExecutor);
        this.startHeartbeatTask();
        this.configReConnTask();
    }

    private static TimerTaskService getTimerTaskService(TimerTaskService taskService) {
        return taskService == null ? new DefaultTimerTaskService() : taskService;
    }

    public void asyncConnect(Node serverNode) throws Exception {
        this.asyncConnect(serverNode, null);
    }

    public void asyncConnect(Node serverNode, Integer timeout) throws Exception {
        this.asyncConnect(serverNode, null, null, timeout);
    }

    public void asyncConnect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        this.connect(serverNode, bindIp, bindPort, null, timeout, false);
    }

    public ClientChannelContext connect(Node serverNode) throws Exception {
        return this.connect(serverNode, null);
    }

    public ClientChannelContext connect(Node serverNode, Integer timeout) throws Exception {
        return this.connect(serverNode, null, 0, timeout);
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, initClientChannelContext, timeout, true);
    }

    private ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout, boolean isSyn) throws Exception {
        boolean isReconnect = initClientChannelContext != null;
        long start = System.currentTimeMillis();
        AsynchronousSocketChannel asynchronousSocketChannel = AsynchronousSocketChannel.open(this.channelGroup);
        long end = System.currentTimeMillis();
        long iv = end - start;
        if (iv >= 100L) {
            log.error("{}, open \u8017\u65f6:{} ms", (Object)serverNode, (Object)iv);
        }
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        InetSocketAddress bind = null;
        if (bindPort != null && bindPort >= 0) {
            bind = StrUtil.isBlank((CharSequence)bindIp) ? new InetSocketAddress(bindPort) : new InetSocketAddress(bindIp, (int)bindPort);
        }
        if (bind != null) {
            asynchronousSocketChannel.bind(bind);
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(serverNode.getIp(), serverNode.getPort());
        ConnectionCompletionVo attachment = new ConnectionCompletionVo(initClientChannelContext, this, isReconnect, asynchronousSocketChannel, serverNode, bindIp, bindPort);
        ConnectionCompletionHandler connectionCompletionHandler = this.clientConfig.getConnectionCompletionHandler();
        if (isSyn) {
            Integer realTimeout = timeout;
            if (realTimeout == null) {
                realTimeout = 5;
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            attachment.setCountDownLatch(countDownLatch);
            try {
                asynchronousSocketChannel.connect(inetSocketAddress, attachment, connectionCompletionHandler);
            }
            catch (Exception e) {
                connectionCompletionHandler.failed((Throwable)e, attachment);
            }
            boolean result = countDownLatch.await(realTimeout.intValue(), TimeUnit.SECONDS);
            if (!result) {
                log.error("connect countDownLatch.await(realTimeout, TimeUnit.SECONDS) \u8fd4\u56de false");
            }
            return attachment.getChannelContext();
        }
        try {
            asynchronousSocketChannel.connect(inetSocketAddress, attachment, connectionCompletionHandler);
        }
        catch (Exception e) {
            connectionCompletionHandler.failed((Throwable)e, attachment);
        }
        return null;
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, null, timeout);
    }

    public AsynchronousChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public TioClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Deprecated
    public TioClientConfig getTioClientConfig() {
        return this.clientConfig;
    }

    public TimerTaskService getTaskService() {
        return this.taskService;
    }

    public void reconnect(ClientChannelContext channelContext, Integer timeout) throws Exception {
        this.connect(channelContext.getServerNode(), channelContext.getBindIp(), channelContext.getBindPort(), channelContext, timeout);
    }

    private void startHeartbeatTask() {
        this.taskService.start();
        if (this.clientConfig.heartbeatTimeout <= 0L) {
            log.warn("\u7528\u6237\u53d6\u6d88\u4e86 mica-net \u7684\u5fc3\u8df3\u5b9a\u65f6\u53d1\u9001\u529f\u80fd\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u81ea\u5b9a\u4e49\u5fc3\u8df3\u673a\u5236");
            return;
        }
        this.taskService.addTask(systemTimer -> new ClientHeartbeatTask((Timer)systemTimer, this.clientConfig));
    }

    private void configReConnTask() {
        ReconnConf reconnConf = this.clientConfig.getReconnConf();
        if (reconnConf == null || reconnConf.getInterval() <= 0L) {
            return;
        }
        reconnConf.setTioClient(this);
        reconnConf.setTaskService(this.taskService);
    }

    public TimerTask schedule(Runnable command, long delay) {
        return this.schedule(command, delay, null);
    }

    public TimerTask schedule(Runnable command, long delay, Executor executor) {
        return this.taskService.addTask(systemTimer -> new TimerTask(delay, (SystemTimer)systemTimer, executor, command){
            final /* synthetic */ SystemTimer val$systemTimer;
            final /* synthetic */ Executor val$executor;
            final /* synthetic */ Runnable val$command;
            {
                this.val$systemTimer = systemTimer;
                this.val$executor = executor;
                this.val$command = runnable;
                super(x0);
            }

            public void run() {
                try {
                    this.val$systemTimer.add((TimerTask)this);
                    if (this.val$executor == null) {
                        this.val$command.run();
                    } else {
                        this.val$executor.execute(this.val$command);
                    }
                }
                catch (Exception e) {
                    log.error("Tio client schedule error", (Throwable)e);
                }
            }
        });
    }

    public TimerTask scheduleOnce(Runnable command, long delay) {
        return this.scheduleOnce(command, delay, null);
    }

    public TimerTask scheduleOnce(final Runnable command, long delay, final Executor executor) {
        return this.taskService.addTask(systemTimer -> new TimerTask(delay){

            public void run() {
                try {
                    if (executor == null) {
                        command.run();
                    } else {
                        executor.execute(command);
                    }
                }
                catch (Exception e) {
                    log.error("Tio client schedule once error", (Throwable)e);
                }
            }
        });
    }

    public boolean stop() {
        boolean ret;
        this.taskService.stop();
        this.clientConfig.remove();
        try {
            this.clientConfig.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.clientConfig.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        this.clientConfig.setStopped(true);
        try {
            ret = this.clientConfig.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.clientConfig.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ret = false;
            Thread.currentThread().interrupt();
            log.error(e.getMessage(), (Throwable)e);
        }
        this.clientConfig.groupExecutor = null;
        this.clientConfig.tioExecutor = null;
        log.info("client resource has released ret:{}", (Object)ret);
        return ret;
    }
}

