/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import net.dreamlu.iot.mqtt.core.common.MqttPendingPublish;
import net.dreamlu.iot.mqtt.core.common.MqttPendingQos2Publish;
import net.dreamlu.iot.mqtt.core.common.TopicFilterType;
import net.dreamlu.iot.mqtt.core.server.model.Subscribe;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;
import org.tio.utils.collection.IntObjectHashMap;
import org.tio.utils.collection.IntObjectMap;

public class InMemoryMqttSessionManager
implements IMqttSessionManager {
    public static final BinaryOperator<Integer> MAX_QOS = (a, b) -> a > b ? a : b;
    private final Map<String, AtomicInteger> messageIdStore = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, Map<String, Integer>> subscribeStore = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Integer>> queueSubscribeStore = new ConcurrentHashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Map<String, Integer>>> shareSubscribeStore = new ConcurrentHashMap<String, Map<String, Map<String, Integer>>>();
    private final Map<String, IntObjectMap<MqttPendingPublish>> pendingPublishStore = new ConcurrentHashMap<String, IntObjectMap<MqttPendingPublish>>();
    private final Map<String, IntObjectMap<MqttPendingQos2Publish>> pendingQos2PublishStore = new ConcurrentHashMap<String, IntObjectMap<MqttPendingQos2Publish>>();

    @Override
    public void addSubscribe(String topicFilter, String clientId, int mqttQoS) {
        Map data;
        TopicFilterType filterType = TopicFilterType.getType((String)topicFilter);
        if (TopicFilterType.QUEUE == filterType) {
            data = this.queueSubscribeStore.computeIfAbsent(topicFilter, key -> new ConcurrentHashMap(16));
        } else if (TopicFilterType.SHARE == filterType) {
            String name = TopicFilterType.getShareGroupName((String)topicFilter);
            Map shareSubscribeMap = this.shareSubscribeStore.computeIfAbsent(name, key -> new ConcurrentHashMap(16));
            data = shareSubscribeMap.computeIfAbsent(topicFilter, key -> new ConcurrentHashMap(16));
        } else {
            data = this.subscribeStore.computeIfAbsent(topicFilter, key -> new ConcurrentHashMap(32));
        }
        Integer existingQos = (Integer)data.get(clientId);
        if (existingQos == null || existingQos < mqttQoS) {
            data.put(clientId, mqttQoS);
        }
    }

    @Override
    public void removeSubscribe(String topicFilter, String clientId) {
        Map<String, Integer> map;
        TopicFilterType filterType = TopicFilterType.getType((String)topicFilter);
        if (filterType == TopicFilterType.NONE) {
            map = this.subscribeStore.get(topicFilter);
        } else if (filterType == TopicFilterType.QUEUE) {
            map = this.queueSubscribeStore.get(topicFilter);
        } else {
            String groupName = TopicFilterType.getShareGroupName((String)topicFilter);
            Map<String, Map<String, Integer>> groupMap = this.shareSubscribeStore.get(groupName);
            if (groupMap == null) {
                return;
            }
            map = groupMap.get(topicFilter);
        }
        if (map == null) {
            return;
        }
        map.remove(clientId);
    }

    @Override
    public Integer searchSubscribe(String topicName, String clientId) {
        Integer qos;
        Map<String, Integer> subscribeData = this.subscribeStore.get(topicName);
        if (subscribeData != null && !subscribeData.isEmpty() && (qos = subscribeData.get(clientId)) != null) {
            return qos;
        }
        Integer subscribeQos = InMemoryMqttSessionManager.searchSubscribeQos(topicName, clientId, this.subscribeStore, TopicFilterType.NONE);
        if (subscribeQos != null) {
            return subscribeQos;
        }
        subscribeQos = InMemoryMqttSessionManager.searchSubscribeQos(topicName, clientId, this.queueSubscribeStore, TopicFilterType.QUEUE);
        if (subscribeQos != null) {
            return subscribeQos;
        }
        for (Map<String, Map<String, Integer>> shareSubscribeStoreMap : this.shareSubscribeStore.values()) {
            subscribeQos = InMemoryMqttSessionManager.searchSubscribeQos(topicName, clientId, shareSubscribeStoreMap, TopicFilterType.SHARE);
            if (subscribeQos == null) continue;
            return subscribeQos;
        }
        return null;
    }

    private static Integer searchSubscribeQos(String topicName, String clientId, Map<String, Map<String, Integer>> subscribeStoreMap, TopicFilterType filterType) {
        Integer qosValue = null;
        Set<String> topicFilterSet = subscribeStoreMap.keySet();
        for (String topicFilter : topicFilterSet) {
            Integer mqttQoS;
            Map<String, Integer> data;
            if (!filterType.match(topicFilter, topicName) || (data = subscribeStoreMap.get(topicFilter)) == null || data.isEmpty() || (mqttQoS = data.get(clientId)) == null) continue;
            if (qosValue == null) {
                qosValue = mqttQoS;
                continue;
            }
            qosValue = (Integer)MAX_QOS.apply(qosValue, mqttQoS);
        }
        return qosValue;
    }

    private static Map<String, Integer> getQueueSubscribeMap(Map<String, Map<String, Integer>> subscribeStore, TopicFilterType filterType, String topicName) {
        HashMap<String, Integer> subscribeMap = new HashMap<String, Integer>(32);
        Set<String> topicFilterSet = subscribeStore.keySet();
        for (String topicFilter : topicFilterSet) {
            Map<String, Integer> data;
            if (!filterType.match(topicFilter, topicName) || (data = subscribeStore.get(topicFilter)) == null || data.isEmpty()) continue;
            data.forEach((clientId, qos) -> subscribeMap.merge((String)clientId, (Integer)qos, (BiFunction<Integer, Integer, Integer>)MAX_QOS));
        }
        return subscribeMap;
    }

    private static Map<String, Map<String, Integer>> getShareSubscribeMap(Map<String, Map<String, Map<String, Integer>>> shareSubscribeStore, TopicFilterType filterType, String topicName) {
        HashMap<String, Map<String, Integer>> shareSubscribeMap = new HashMap<String, Map<String, Integer>>(32);
        for (Map.Entry<String, Map<String, Map<String, Integer>>> entry : shareSubscribeStore.entrySet()) {
            String entryKey = entry.getKey();
            Map<String, Map<String, Integer>> entryValue = entry.getValue();
            Map<String, Integer> map = InMemoryMqttSessionManager.getQueueSubscribeMap(entryValue, filterType, topicName);
            if (map == null || map.isEmpty()) continue;
            shareSubscribeMap.put(entryKey, map);
        }
        return shareSubscribeMap;
    }

    private static void randomStrategy(Map<String, Integer> subscribeMap, Map<String, Integer> randomSubscribeMap) {
        String[] keys = randomSubscribeMap.keySet().toArray(new String[0]);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String key = keys[((Random)random).nextInt(keys.length)];
        subscribeMap.merge(key, randomSubscribeMap.get(key), MAX_QOS);
    }

    @Override
    public List<Subscribe> searchSubscribe(String topicName) {
        Map<String, Map<String, Integer>> shareSubscribeMap;
        HashMap<String, Integer> subscribeMap = new HashMap<String, Integer>(32);
        Set<String> topicFilterSet = this.subscribeStore.keySet();
        for (String topicFilter : topicFilterSet) {
            Object data;
            if (!TopicUtil.match((String)topicFilter, (String)topicName) || (data = this.subscribeStore.get(topicFilter)) == null || data.isEmpty()) continue;
            data.forEach((clientId, qos) -> subscribeMap.merge((String)clientId, (Integer)qos, (BiFunction<Integer, Integer, Integer>)MAX_QOS));
        }
        Map<String, Integer> queueSubscribeMap = InMemoryMqttSessionManager.getQueueSubscribeMap(this.queueSubscribeStore, TopicFilterType.QUEUE, topicName);
        if (!queueSubscribeMap.isEmpty()) {
            InMemoryMqttSessionManager.randomStrategy(subscribeMap, queueSubscribeMap);
        }
        if (!(shareSubscribeMap = InMemoryMqttSessionManager.getShareSubscribeMap(this.shareSubscribeStore, TopicFilterType.SHARE, topicName)).isEmpty()) {
            for (Map map : shareSubscribeMap.values()) {
                InMemoryMqttSessionManager.randomStrategy(subscribeMap, map);
            }
        }
        ArrayList<Subscribe> subscribeList = new ArrayList<Subscribe>();
        subscribeMap.forEach((clientId, qos) -> subscribeList.add(new Subscribe((String)clientId, (int)qos)));
        subscribeMap.clear();
        return subscribeList;
    }

    @Override
    public List<Subscribe> getSubscriptions(String clientId) {
        ArrayList<Subscribe> subscribeList = new ArrayList<Subscribe>();
        InMemoryMqttSessionManager.getSubscriptions(subscribeList, this.subscribeStore, clientId);
        InMemoryMqttSessionManager.getSubscriptions(subscribeList, this.queueSubscribeStore, clientId);
        for (Map<String, Map<String, Integer>> shareSubscribeMap : this.shareSubscribeStore.values()) {
            InMemoryMqttSessionManager.getSubscriptions(subscribeList, shareSubscribeMap, clientId);
        }
        return subscribeList;
    }

    private static void getSubscriptions(List<Subscribe> subscribeList, Map<String, Map<String, Integer>> subscribeStoreMap, String clientId) {
        Set<Map.Entry<String, Map<String, Integer>>> entrySet = subscribeStoreMap.entrySet();
        for (Map.Entry<String, Map<String, Integer>> mapEntry : entrySet) {
            Integer qos;
            Map<String, Integer> mapEntryValue = mapEntry.getValue();
            if (mapEntryValue == null || mapEntryValue.isEmpty() || (qos = mapEntryValue.get(clientId)) == null) continue;
            String topicFilter = mapEntry.getKey();
            subscribeList.add(new Subscribe(topicFilter, clientId, qos));
        }
    }

    @Override
    public void addPendingPublish(String clientId, int messageId, MqttPendingPublish pendingPublish) {
        Map data = (Map)this.pendingPublishStore.computeIfAbsent(clientId, key -> new IntObjectHashMap(16));
        data.put(messageId, pendingPublish);
    }

    @Override
    public MqttPendingPublish getPendingPublish(String clientId, int messageId) {
        Map data = (Map)this.pendingPublishStore.get(clientId);
        if (data == null) {
            return null;
        }
        return (MqttPendingPublish)data.get(messageId);
    }

    @Override
    public void removePendingPublish(String clientId, int messageId) {
        Map data = (Map)this.pendingPublishStore.get(clientId);
        if (data != null) {
            data.remove(messageId);
        }
    }

    @Override
    public void addPendingQos2Publish(String clientId, int messageId, MqttPendingQos2Publish pendingQos2Publish) {
        Map data = (Map)this.pendingQos2PublishStore.computeIfAbsent(clientId, key -> new IntObjectHashMap());
        data.put(messageId, pendingQos2Publish);
    }

    @Override
    public MqttPendingQos2Publish getPendingQos2Publish(String clientId, int messageId) {
        Map data = (Map)this.pendingQos2PublishStore.get(clientId);
        if (data == null) {
            return null;
        }
        return (MqttPendingQos2Publish)data.get(messageId);
    }

    @Override
    public void removePendingQos2Publish(String clientId, int messageId) {
        Map data = (Map)this.pendingQos2PublishStore.get(clientId);
        if (data != null) {
            data.remove(messageId);
        }
    }

    @Override
    public int getMessageId(String clientId) {
        AtomicInteger value = this.messageIdStore.computeIfAbsent(clientId, key -> new AtomicInteger(1));
        value.compareAndSet(65535, 1);
        return value.getAndIncrement();
    }

    @Override
    public boolean hasSession(String clientId) {
        return this.pendingQos2PublishStore.containsKey(clientId) || this.pendingPublishStore.containsKey(clientId) || this.messageIdStore.containsKey(clientId) || this.subscribeStore.values().stream().anyMatch(data -> data.containsKey(clientId)) || this.queueSubscribeStore.values().stream().anyMatch(data -> data.containsKey(clientId)) || this.shareSubscribeStore.values().stream().flatMap(map -> map.values().stream()).anyMatch(data -> data.containsKey(clientId));
    }

    @Override
    public boolean expire(String clientId, int sessionExpirySeconds) {
        return false;
    }

    @Override
    public boolean active(String clientId) {
        return false;
    }

    public void removeSubscribe(String clientId) {
        this.subscribeStore.forEach((key, value) -> {
            Integer cfr_ignored_0 = (Integer)value.remove(clientId);
        });
        this.queueSubscribeStore.forEach((key, value) -> {
            Integer cfr_ignored_0 = (Integer)value.remove(clientId);
        });
        this.shareSubscribeStore.forEach((group, groupValue) -> groupValue.forEach((key, value) -> {
            Integer cfr_ignored_0 = (Integer)value.remove(clientId);
        }));
    }

    @Override
    public void remove(String clientId) {
        this.removeSubscribe(clientId);
        this.pendingPublishStore.remove(clientId);
        this.pendingQos2PublishStore.remove(clientId);
        this.messageIdStore.remove(clientId);
    }

    @Override
    public void clean() {
        this.subscribeStore.clear();
        this.queueSubscribeStore.clear();
        this.shareSubscribeStore.clear();
        this.pendingPublishStore.clear();
        this.pendingQos2PublishStore.clear();
        this.messageIdStore.clear();
    }
}

