/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.http.api.result;

import java.util.HashMap;
import net.dreamlu.iot.mqtt.core.server.http.api.code.ResultCode;
import org.tio.http.common.HeaderName;
import org.tio.http.common.HeaderValue;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.utils.json.JsonUtil;

public final class Result {
    public static HttpResponse ok() {
        return Result.ok(new HttpResponse());
    }

    public static HttpResponse ok(HttpResponse response) {
        ResultCode resultCode = ResultCode.SUCCESS;
        HashMap<String, Integer> json = new HashMap<String, Integer>(2);
        json.put("code", resultCode.getResultCode());
        return Result.result(response, resultCode, json);
    }

    public static HttpResponse ok(Object data) {
        return Result.ok(new HttpResponse(), data);
    }

    public static HttpResponse ok(HttpRequest request, Object data) {
        return Result.ok(new HttpResponse(request), data);
    }

    public static HttpResponse ok(HttpResponse response, Object data) {
        ResultCode resultCode = ResultCode.SUCCESS;
        HashMap<String, Object> json = new HashMap<String, Object>(4);
        json.put("code", resultCode.getResultCode());
        json.put("data", data);
        return Result.result(response, resultCode, json);
    }

    public static HttpResponse fail(ResultCode resultCode) {
        return Result.fail(new HttpResponse(), resultCode);
    }

    public static HttpResponse fail(HttpRequest request, ResultCode resultCode) {
        return Result.fail(new HttpResponse(request), resultCode);
    }

    public static HttpResponse fail(HttpResponse response, ResultCode resultCode) {
        HashMap<String, Integer> json = new HashMap<String, Integer>(2);
        json.put("code", resultCode.getResultCode());
        return Result.result(response, resultCode, json);
    }

    private static HttpResponse result(HttpResponse response, ResultCode resultCode, Object value) {
        response.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_PLAIN_JSON);
        response.setStatus(resultCode.getStatusCode());
        response.setBody(JsonUtil.toJsonString((Object)value).getBytes(HttpConst.CHARSET));
        response.setCharset(HttpConst.CHARSET);
        return response;
    }
}

